/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.listeners;

import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.utils.InventoryFactory;
import net.shortninja.staffplus.core.domain.staff.chests.ChestGUI;
import net.shortninja.staffplus.core.domain.staff.chests.ChestGuiType;
import net.shortninja.staffplus.core.domain.staff.freeze.FreezeGui;
import net.shortninja.staffplus.core.domain.staff.freeze.config.FreezeConfiguration;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;

@IocBukkitListener
public class InventoryClose
implements Listener {
    private final OnlineSessionsManager sessionManager;
    private final InventoryFactory inventoryFactory;
    private final FreezeConfiguration freezeConfiguration;

    public InventoryClose(OnlineSessionsManager sessionManager, InventoryFactory inventoryFactory, FreezeConfiguration freezeConfiguration) {
        this.sessionManager = sessionManager;
        this.inventoryFactory = inventoryFactory;
        this.freezeConfiguration = freezeConfiguration;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (this.sessionManager.has(player.getUniqueId())) {
            PlayerSession playerSession = this.sessionManager.get(player);
            if (playerSession.isFrozen() && this.freezeConfiguration.prompt) {
                Bukkit.getScheduler().runTaskLater((Plugin)StaffPlusPlus.get(), () -> new FreezeGui(this.freezeConfiguration.promptTitle).show(player), 1L);
                return;
            }
            if (playerSession.getCurrentGui().isPresent() && playerSession.getCurrentGui().get() instanceof ChestGUI) {
                ChestGUI chestGUI = (ChestGUI)playerSession.getCurrentGui().get();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)StaffPlusPlus.get(), () -> {
                    if (chestGUI.getChestGuiType() == ChestGuiType.ENDER_CHEST_EXAMINE && chestGUI.getTargetPlayer() != null && !chestGUI.getTargetPlayer().isOnline()) {
                        this.inventoryFactory.saveEnderchestOffline(chestGUI.getTargetPlayer(), chestGUI.getTargetInventory());
                    }
                    if (chestGUI.getChestGuiType() == ChestGuiType.PLAYER_INVENTORY_EXAMINE && chestGUI.getTargetPlayer() != null && !chestGUI.getTargetPlayer().isOnline()) {
                        this.inventoryFactory.saveInventoryOffline(chestGUI.getTargetPlayer(), chestGUI.getTargetInventory());
                    }
                });
            }
            if (playerSession.getCurrentGui().isPresent()) {
                playerSession.setCurrentGui(null);
            }
        }
    }
}

