/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.listeners;

import net.shortninja.staffplus.core.application.session.OnlinePlayerSession;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.staff.freeze.config.FreezeConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;

@IocBukkitListener
public class EntityDamage
implements Listener {
    private final FreezeConfiguration freezeConfiguration;
    private final OnlineSessionsManager sessionManager;

    public EntityDamage(FreezeConfiguration freezeConfiguration, OnlineSessionsManager sessionManager) {
        this.freezeConfiguration = freezeConfiguration;
        this.sessionManager = sessionManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamage(EntityDamageEvent event) {
        PlayerSession session;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        if (!this.sessionManager.has(entity.getUniqueId())) {
            event.setCancelled(true);
        }
        if (this.inStaffMode(session = this.sessionManager.get((Player)entity)) || this.isFrozen(session) || session.isProtected()) {
            event.setCancelled(true);
        }
    }

    private boolean inStaffMode(OnlinePlayerSession session) {
        return session.isInStaffMode() && session.getModeConfig().get().isModeInvincible();
    }

    private boolean isFrozen(OnlinePlayerSession session) {
        return !this.freezeConfiguration.damage && session.isFrozen();
    }
}

