/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.listeners;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMulti;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.chat.ChatInterceptor;
import net.shortninja.staffplus.core.domain.staff.tracing.TraceService;
import net.shortninja.staffplus.core.domain.staff.tracing.TraceType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@IocBukkitListener
public class AsyncPlayerChat
implements Listener {
    private final List<ChatInterceptor> chatInterceptors;
    private final TraceService traceService;

    public AsyncPlayerChat(@IocMulti(value=ChatInterceptor.class) List<ChatInterceptor> chatInterceptors, TraceService traceService) {
        this.chatInterceptors = chatInterceptors.stream().sorted(Comparator.comparingInt(ChatInterceptor::getPriority)).collect(Collectors.toList());
        this.traceService = traceService;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        for (ChatInterceptor chatInterceptor : this.chatInterceptors) {
            boolean cancel = chatInterceptor.intercept(event);
            if (!cancel) continue;
            event.setCancelled(true);
            return;
        }
        this.traceService.sendTraceMessage(TraceType.CHAT, player.getUniqueId(), event.getMessage());
    }
}

