/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.ip;

import java.util.List;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.ip.PlayerIpRecord;
import net.shortninja.staffplus.core.domain.player.ip.database.PlayerIpRepository;
import net.shortninja.staffplusplus.ips.IpHistoryClearedEvent;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@IocBean
public class PlayerIpService {
    private final PlayerIpRepository playerIpRepository;
    private final Options options;

    public PlayerIpService(PlayerIpRepository playerIpRepository, Options options) {
        this.playerIpRepository = playerIpRepository;
        this.options = options;
    }

    public List<PlayerIpRecord> getPlayersMatchingIp(String ipAddress) {
        return ipAddress.contains("/") ? this.getMatchedBySubnet(ipAddress) : this.getMatchedByIp(ipAddress);
    }

    public void savePlayerIp(Player player) {
        String ipFromPlayer = BukkitUtils.getIpFromPlayer(player);
        this.playerIpRepository.save(player.getUniqueId(), player.getName(), ipFromPlayer, this.options.serverName);
    }

    public List<PlayerIpRecord> getMatchedBySubnet(String cidr) {
        String[] range = JavaUtils.cidrToIpRange(cidr);
        long lower = JavaUtils.convertIp(range[0]);
        long upper = JavaUtils.convertIp(range[1]);
        return this.playerIpRepository.findInSubnet(lower, upper);
    }

    public List<PlayerIpRecord> getMatchedByIp(String ipAddress) {
        return this.playerIpRepository.findWithIp(JavaUtils.convertIp(ipAddress));
    }

    public void clearHistory(CommandSender sender, SppPlayer player) {
        this.playerIpRepository.deleteRecordsFor(player);
        BukkitUtils.sendEvent(new IpHistoryClearedEvent(sender, player));
    }
}

