/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.gui.hub;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@GuiController
public class MinerGuiController {
    private final PlayerManager playerManager;
    private final Messages messages;
    private final Options options;

    public MinerGuiController(PlayerManager playerManager, Messages messages, Options options) {
        this.playerManager = playerManager;
        this.messages = messages;
        this.options = options;
    }

    @GuiAction(value="miners/view")
    public GuiTemplate getMinersView(@GuiParam(value="page", defaultValue="0") int page) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("players", this.getPlayers(page));
        return GuiTemplate.template("gui/player/miners-overview.ftl", params);
    }

    private List<SppPlayer> getPlayers(int page) {
        List onlinePlayers = this.playerManager.getOnlineSppPlayers().stream().filter(p -> p.getPlayer().getLocation().getBlockY() < this.options.staffItemsConfiguration.getGuiModeConfiguration().modeGuiMinerLevel).collect(Collectors.toList());
        return JavaUtils.getPageOfList(new ArrayList(onlinePlayers), page, 45);
    }

    @GuiAction(value="miners/teleport")
    public void changeGlass(Player player, @GuiParam(value="to") String toPlayerUuid) {
        Optional<SppPlayer> p = this.playerManager.getOnlinePlayer(UUID.fromString(toPlayerUuid));
        if (p.isPresent()) {
            player.teleport((Entity)p.get().getPlayer());
        } else {
            this.messages.send((CommandSender)player, this.messages.playerOffline, this.messages.prefixGeneral);
        }
    }
}

