/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.gui.hub;

import java.util.HashMap;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.domain.player.gui.hub.views.ColorViewBuilder;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@GuiController
public class HubGuiController {
    private final ColorViewBuilder colorViewBuilder;
    private final PlayerSettingsRepository playerSettingsRepository;

    public HubGuiController(ColorViewBuilder colorViewBuilder, PlayerSettingsRepository playerSettingsRepository) {
        this.colorViewBuilder = colorViewBuilder;
        this.playerSettingsRepository = playerSettingsRepository;
    }

    @GuiAction(value="hub/view")
    public AsyncGui<GuiTemplate> getHubView(Player player) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("settings", this.playerSettingsRepository.get((OfflinePlayer)player));
            return GuiTemplate.template("gui/hub/hub.ftl", params);
        });
    }

    @GuiAction(value="hub/view/color-select")
    public TubingGui getGlassView(Player player) {
        return this.colorViewBuilder.buildGui();
    }

    @GuiAction(value="hub/change-color")
    public AsyncGui<String> changeGlass(Player player, @GuiParam(value="color") String color) {
        return AsyncGui.async(() -> {
            Material material = Material.valueOf((String)color);
            PlayerSettings session = this.playerSettingsRepository.get((OfflinePlayer)player);
            session.setGlassColor(material);
            this.playerSettingsRepository.save(session);
            return "hub/view";
        });
    }
}

