/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.gui;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplusplus.session.SppPlayer;

@GuiController
public class StaffMembersGuiController {
    @ConfigProperty(value="permissions:member")
    private String permissionMember;
    private final Options options;
    private final OnlineSessionsManager sessionManager;
    private final PermissionHandler permissionHandler;
    private final PlayerManager playerManager;

    public StaffMembersGuiController(Options options, OnlineSessionsManager sessionManager, PermissionHandler permissionHandler, PlayerManager playerManager) {
        this.options = options;
        this.sessionManager = sessionManager;
        this.permissionHandler = permissionHandler;
        this.playerManager = playerManager;
    }

    @GuiAction(value="membersGUI")
    public GuiTemplate getItems(@GuiParam(value="page", defaultValue="0") int page) {
        List<SppPlayer> players = this.options.staffItemsConfiguration.getCounterModeConfiguration().isModeCounterShowStaffMode() ? this.getModePlayers() : this.playerManager.getOnlineSppPlayers();
        List sppPlayers = players.stream().filter(p -> this.permissionHandler.has(p.getPlayer(), this.permissionMember)).collect(Collectors.toList());
        List pageOfList = JavaUtils.getPageOfList(sppPlayers, page, 45);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", this.options.staffItemsConfiguration.getCounterModeConfiguration().getTitle());
        params.put("players", pageOfList);
        return GuiTemplate.template("gui/player/player-overview.ftl", params);
    }

    private List<SppPlayer> getModePlayers() {
        return this.sessionManager.getAll().stream().map(s -> this.playerManager.getOnlinePlayer(s.getUuid())).flatMap(optional -> optional.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }
}

