/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.gui;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.player.gui.model.PlayerOverviewModel;
import net.shortninja.staffplus.core.domain.player.ip.database.PlayerIpRepository;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBan;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBanConfiguration;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBanService;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanService;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.config.BanConfiguration;
import net.shortninja.staffplus.core.domain.staff.mute.MuteService;
import net.shortninja.staffplus.core.domain.staff.mute.config.MuteConfiguration;
import net.shortninja.staffplus.core.domain.staff.reporting.Report;
import net.shortninja.staffplus.core.domain.staff.reporting.ReportService;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.config.WarningConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import net.shortninja.staffplusplus.warnings.IWarning;
import net.shortninja.staffplusplus.warnings.WarningFilters;
import net.shortninja.staffplusplus.warnings.WarningService;

@GuiController
public class PlayersGuiController {
    @ConfigProperty(value="reports-module.enabled")
    private boolean reportsEnabled;
    private final PlayerManager playerManager;
    private final BanService banService;
    private final IpBanService ipBanService;
    private final BanConfiguration banConfiguration;
    private final IpBanConfiguration ipBanConfiguration;
    private final MuteService muteService;
    private final MuteConfiguration muteConfiguration;
    private final PlayerIpRepository playerIpRepository;
    private final ReportService reportService;
    private final WarningService warningService;
    private final WarningConfiguration warningConfiguration;

    public PlayersGuiController(PlayerManager playerManager, BanService banService, IpBanService ipBanService, BanConfiguration banConfiguration, IpBanConfiguration ipBanConfiguration, MuteService muteService, MuteConfiguration muteConfiguration, PlayerIpRepository playerIpRepository, ReportService reportService, WarningService warningService, WarningConfiguration warningConfiguration) {
        this.playerManager = playerManager;
        this.banService = banService;
        this.ipBanService = ipBanService;
        this.banConfiguration = banConfiguration;
        this.ipBanConfiguration = ipBanConfiguration;
        this.muteService = muteService;
        this.muteConfiguration = muteConfiguration;
        this.playerIpRepository = playerIpRepository;
        this.reportService = reportService;
        this.warningService = warningService;
        this.warningConfiguration = warningConfiguration;
    }

    @GuiAction(value="players/view/detail")
    public GuiTemplate getItems(@GuiParam(value="targetPlayerName") String playerName) {
        SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(playerName).orElseThrow(() -> new PlayerNotFoundException(playerName));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("target", sppPlayer);
        params.put("model", new PlayerOverviewModel(this.banConfiguration.enabled ? this.banService.getBanByBannedUuid(sppPlayer.getId()) : Optional.empty(), this.muteConfiguration.muteEnabled ? this.muteService.getMuteByMutedUuid(sppPlayer.getId()) : Optional.empty(), this.ipBanConfiguration.enabled ? this.getIpBans(sppPlayer) : Collections.emptyList(), this.reportsEnabled ? this.getReports(sppPlayer) : Collections.emptyList(), this.reportsEnabled ? this.getReported(sppPlayer) : Collections.emptyList(), this.warningConfiguration.isEnabled() ? this.getWarnings(sppPlayer) : Collections.emptyList()));
        return GuiTemplate.template("gui/player/player-detail.ftl", params);
    }

    @GuiAction(value="players/view/select-overview-type")
    public GuiTemplate getOverviewSelectionView() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return GuiTemplate.template("gui/player/player-overview-select.ftl", params);
    }

    @GuiAction(value="players/view/overview/online")
    public GuiTemplate getOverviewOnlinePlayers(@GuiParam(value="page", defaultValue="0") int page) {
        List<SppPlayer> onlineSppPlayers = this.playerManager.getOnlineSppPlayers();
        List<SppPlayer> pagedPlayers = JavaUtils.getPageOfList(onlineSppPlayers, page, 45);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", "Online players");
        params.put("players", pagedPlayers);
        return GuiTemplate.template("gui/player/player-overview.ftl", params);
    }

    @GuiAction(value="players/view/overview/offline")
    public GuiTemplate getOverviewOfflinePlayers(@GuiParam(value="page", defaultValue="0") int page) {
        List<SppPlayer> onlineSppPlayers = this.playerManager.getOfflinePlayers();
        List<SppPlayer> pagedPlayers = JavaUtils.getPageOfList(onlineSppPlayers, page, 45);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", "Offline players");
        params.put("players", pagedPlayers);
        return GuiTemplate.template("gui/player/player-overview.ftl", params);
    }

    private List<? extends IWarning> getWarnings(SppPlayer sppPlayer) {
        return this.warningService.findWarnings(new WarningFilters.WarningFiltersBuilder().culprit(sppPlayer).expired(false).build(), 0, 1000);
    }

    private List<IpBan> getIpBans(SppPlayer sppPlayer) {
        Optional<String> ipAddress = sppPlayer.isOnline() ? Optional.of(BukkitUtils.getIpFromPlayer(sppPlayer.getPlayer())) : this.playerIpRepository.getLastIp(sppPlayer.getId());
        return ipAddress.isPresent() ? this.ipBanService.findMatchingIpBans(ipAddress.get()) : Collections.emptyList();
    }

    private List<Report> getReports(SppPlayer sppPlayer) {
        return this.reportService.getMyReports(sppPlayer.getId());
    }

    private List<Report> getReported(SppPlayer sppPlayer) {
        return this.reportService.getReported(sppPlayer.getId(), 0, 100);
    }
}

