/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.gui;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionService;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:players", permissions={"permissions:players"}, description="Open player details gui.", usage="[player]", playerRetrievalStrategy=PlayerRetrievalStrategy.OPTIONAL_BOTH)
@IocBean
@IocMultiProvider(value={SppCommand.class})
public class PlayersCmd
extends AbstractCmd {
    private final GuiActionService guiActionService;
    private final PlayerManager playerManager;

    public PlayersCmd(Messages messages, PermissionHandler permissionHandler, CommandService commandService, GuiActionService guiActionService, PlayerManager playerManager) {
        super(messages, permissionHandler, commandService);
        this.guiActionService = guiActionService;
        this.playerManager = playerManager;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        this.validateIsPlayer(sender);
        if (args.length == 0) {
            this.guiActionService.executeAction((Player)sender, "players/view/select-overview-type");
            return true;
        }
        this.guiActionService.executeAction((Player)sender, "players/view/detail?targetPlayerName=" + player.getUsername());
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 0;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        if (args.length == 0) {
            return Optional.empty();
        }
        return Optional.of(args[0]);
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args, String[] sppArgs) throws IllegalArgumentException {
        String currentArg;
        String string = currentArg = args.length > 0 ? args[args.length - 1] : "";
        if (args.length == 1) {
            return this.playerManager.getAllPlayerNames().stream().filter(s -> currentArg.isEmpty() || s.contains(currentArg)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

