/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.domain.player.database.PlayerRepository;
import net.shortninja.staffplus.core.domain.player.database.StoredPlayer;
import net.shortninja.staffplus.core.domain.player.providers.OfflinePlayerProvider;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

@IocBean
public class PlayerManager {
    @ConfigProperty(value="server-name")
    private String serverName;
    @ConfigProperty(value="offline-player-cache")
    public boolean offlinePlayerCache;
    private final OfflinePlayerProvider offlinePlayerProvider;
    private final Set<String> cachedPlayerNames;
    private final Set<SppPlayer> cachedSppPlayers;
    private final PlayerRepository playerRepository;

    public PlayerManager(OfflinePlayerProvider offlinePlayerProvider, PlayerRepository playerRepository) {
        this.offlinePlayerProvider = offlinePlayerProvider;
        this.playerRepository = playerRepository;
        HashSet<String> playerNames = new HashSet<String>();
        HashSet<SppPlayer> sppPlayers = new HashSet<SppPlayer>();
        if (this.offlinePlayerCache) {
            for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                String name = offlinePlayer.getName();
                if (!StringUtils.isNotEmpty(name)) continue;
                playerNames.add(name);
                sppPlayers.add(new SppPlayer(offlinePlayer.getUniqueId(), offlinePlayer.getName(), offlinePlayer));
            }
        }
        this.cachedPlayerNames = playerNames;
        this.cachedSppPlayers = sppPlayers;
    }

    public Optional<SppPlayer> getOnOrOfflinePlayer(String playerName) {
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player == null) {
            return this.offlinePlayerProvider.findUser(playerName);
        }
        return Optional.of(new SppPlayer(player.getUniqueId(), playerName, player));
    }

    public Set<SppPlayer> getOnAndOfflinePlayers() {
        return new HashSet<SppPlayer>(this.cachedSppPlayers);
    }

    public List<SppPlayer> getOfflinePlayers() {
        return this.cachedSppPlayers.stream().filter(p -> !p.isOnline()).collect(Collectors.toList());
    }

    public Optional<SppPlayer> getOnOrOfflinePlayer(UUID playerUuid) {
        if (playerUuid == null) {
            return Optional.empty();
        }
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null) {
            return this.offlinePlayerProvider.findUser(playerUuid);
        }
        return Optional.of(new SppPlayer(player.getUniqueId(), player.getName(), player));
    }

    public Optional<SppPlayer> getOnlinePlayer(UUID uuid) {
        if (uuid == null) {
            return Optional.empty();
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of(new SppPlayer(player.getUniqueId(), player.getName(), player));
    }

    public Optional<SppPlayer> getOnlinePlayer(String playerName) {
        Player player = Bukkit.getPlayer((String)playerName);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of(new SppPlayer(player.getUniqueId(), player.getName(), player));
    }

    public Set<String> getAllPlayerNames() {
        return new HashSet<String>(this.cachedPlayerNames);
    }

    public void syncPlayer(Player player) {
        this.cachedPlayerNames.add(player.getName());
        List existingCache = this.cachedSppPlayers.stream().filter(p -> p.getId().equals(player.getUniqueId())).collect(Collectors.toList());
        this.cachedSppPlayers.removeAll(existingCache);
        this.cachedSppPlayers.add(new SppPlayer(player.getUniqueId(), player.getName(), player));
    }

    public void storePlayer(OfflinePlayer player) {
        Optional<StoredPlayer> storedPlayer = this.playerRepository.findPlayer(player.getUniqueId());
        if (storedPlayer.isPresent()) {
            if (!storedPlayer.get().getServers().contains(this.serverName)) {
                storedPlayer.get().addServer(this.serverName);
                this.playerRepository.update(storedPlayer.get());
            }
        } else {
            this.playerRepository.save(new StoredPlayer(player.getUniqueId(), player.getName(), Sets.newHashSet((Object[])new String[]{this.serverName})));
        }
    }

    public Collection<? extends Player> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers();
    }

    public List<String> getOnlinePlayerNames() {
        return Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).collect(Collectors.toList());
    }

    public List<SppPlayer> getOnlineSppPlayers() {
        return Bukkit.getOnlinePlayers().stream().map(p -> new SppPlayer(p.getUniqueId(), p.getName(), (Player)p)).collect(Collectors.toList());
    }
}

