/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.confirmation;

import java.util.Map;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.domain.confirmation.ChoiceAction;
import net.shortninja.staffplus.core.domain.confirmation.ChoiceChatService;
import net.shortninja.staffplus.core.domain.confirmation.ConfirmationConfig;
import net.shortninja.staffplus.core.domain.confirmation.ConfirmationGui;
import net.shortninja.staffplus.core.domain.staff.mode.item.ConfirmationType;
import org.bukkit.entity.Player;

@IocBean
public class ConfirmationService {
    private final ChoiceChatService choiceChatService;

    public ConfirmationService(ChoiceChatService choiceChatService) {
        this.choiceChatService = choiceChatService;
    }

    public void showConfirmation(Player player, ConfirmationConfig confirmationConfig, Map<String, String> placeholders, ChoiceAction confirmAction, ChoiceAction cancelAction) {
        String confirmationMessage = confirmationConfig.getConfirmationMessage();
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            confirmationMessage = confirmationMessage.replace(entry.getKey(), entry.getValue());
        }
        if (confirmationConfig.getConfirmationType() == ConfirmationType.GUI) {
            new ConfirmationGui("Confirm?", confirmationMessage, confirmAction, cancelAction).show(player);
        } else {
            this.choiceChatService.sendConfirmationChoiceMessage(player, confirmationMessage, confirmAction, cancelAction);
        }
    }
}

