/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.confirmation;

import net.shortninja.staffplus.core.common.Items;
import net.shortninja.staffplus.core.common.gui.AbstractGui;
import net.shortninja.staffplus.core.common.gui.IAction;
import net.shortninja.staffplus.core.domain.confirmation.ChoiceAction;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class ConfirmationGui
extends AbstractGui {
    private final ChoiceAction onConfirm;
    private final ChoiceAction onCancel;
    private final String confirmationMessage;
    private boolean closeOnCancel = true;
    private boolean closeOnConfirmation = true;

    public ConfirmationGui(String title, String confirmationMessage, ChoiceAction onConfirm, ChoiceAction onCancel) {
        super(27, title);
        this.confirmationMessage = confirmationMessage;
        this.onConfirm = onConfirm;
        this.onCancel = onCancel;
    }

    public ConfirmationGui closeOnCancel(boolean closeOnCancel) {
        this.closeOnCancel = closeOnCancel;
        return this;
    }

    public ConfirmationGui closeOnConfirmation(boolean closeOnConfirmation) {
        this.closeOnConfirmation = closeOnConfirmation;
        return this;
    }

    @Override
    public void buildGui() {
        this.addBook(4);
        this.addCancelItem(this.onCancel, 9);
        this.addCancelItem(this.onCancel, 10);
        this.addCancelItem(this.onCancel, 18);
        this.addCancelItem(this.onCancel, 19);
        this.addConfirmItem(this.onConfirm, 16);
        this.addConfirmItem(this.onConfirm, 17);
        this.addConfirmItem(this.onConfirm, 25);
        this.addConfirmItem(this.onConfirm, 26);
    }

    private void addBook(int slot) {
        ItemStack itemStack = Items.createBook("&6Confirm", this.confirmationMessage);
        this.setItem(slot, itemStack, null);
    }

    private void addConfirmItem(final ChoiceAction onConfirm, int slot) {
        ItemStack itemStack = Items.createGreenColoredGlass("Confirm", "");
        this.setItem(slot, itemStack, new IAction(){

            @Override
            public void click(Player player, ItemStack item, int slot, ClickType clickType) {
                onConfirm.execute(player);
            }

            @Override
            public boolean shouldClose(Player player) {
                return ConfirmationGui.this.closeOnConfirmation;
            }
        });
    }

    private void addCancelItem(final ChoiceAction onCancel, int slot) {
        ItemStack itemStack = Items.createRedColoredGlass("Cancel", "");
        this.setItem(slot, itemStack, new IAction(){

            @Override
            public void click(Player player, ItemStack item, int slot, ClickType clickType) {
                onCancel.execute(player);
            }

            @Override
            public boolean shouldClose(Player player) {
                return ConfirmationGui.this.closeOnCancel;
            }
        });
    }
}

