/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.confirmation;

import be.garagepoort.staffplusplus.craftbukkit.common.json.rayzr.JSONMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.JsonSenderService;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.domain.confirmation.ChoiceAction;
import org.bukkit.entity.Player;

@IocBean
public class ChoiceChatService {
    private static Map<UUID, ChoiceAction> option1Actions = new HashMap<UUID, ChoiceAction>();
    private static Map<UUID, ChoiceAction> option2actions = new HashMap<UUID, ChoiceAction>();
    private final JsonSenderService jsonSenderService;

    public ChoiceChatService(JsonSenderService jsonSenderService) {
        this.jsonSenderService = jsonSenderService;
    }

    public void sendConfirmationChoiceMessage(Player player, String message, ChoiceAction choiceAction, ChoiceAction cancelAction) {
        this.sendChoiceMessage(player, message, "&aConfirm", choiceAction, "&cCancel", cancelAction);
    }

    public void sendChoiceMessage(Player player, String message, String option1Message, ChoiceAction option1Action, String option2Message, ChoiceAction option2Action) {
        UUID uuid = UUID.randomUUID();
        option1Actions.put(uuid, option1Action);
        option2actions.put(uuid, option2Action);
        JSONMessage jsonMessage = JavaUtils.buildChoiceMessage(message, option1Message, "staffplusplus:choice-action option1 " + uuid, option2Message, "staffplusplus:choice-action option2 " + uuid);
        this.jsonSenderService.send(jsonMessage, player);
    }

    public void selectOption1(UUID uuid, Player player) {
        if (!option1Actions.containsKey(uuid)) {
            throw new BusinessException("&CNo action found");
        }
        ChoiceAction choiceAction = option1Actions.get(uuid);
        option1Actions.remove(uuid);
        option2actions.remove(uuid);
        choiceAction.execute(player);
    }

    public void selectOption2(UUID uuid, Player player) {
        if (!option2actions.containsKey(uuid)) {
            throw new BusinessException("&CNo action found");
        }
        ChoiceAction cancelAction = option2actions.get(uuid);
        option1Actions.remove(uuid);
        option2actions.remove(uuid);
        cancelAction.execute(player);
    }
}

