/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.commanddetection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigObjectList;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.actions.ActionFilter;
import net.shortninja.staffplus.core.domain.actions.ActionService;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommand;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommandMapper;
import net.shortninja.staffplus.core.domain.commanddetection.CommandDetectionGroupConfiguration;
import net.shortninja.staffplusplus.commanddetection.CommandDetectedEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

@IocBukkitListener(conditionalOnProperty="command-detection.enabled=true")
public class CommandDetectionListener
implements Listener {
    @ConfigProperty(value="permissions:command-detection-bypass")
    private String permissionCommandDetectionBypass;
    @ConfigProperty(value="command-detection.command-groups")
    @ConfigObjectList(value=CommandDetectionGroupConfiguration.class)
    private List<CommandDetectionGroupConfiguration> commandsToDetect;
    private final BukkitUtils bukkitUtils;
    private final ActionService actionService;
    private final ConfiguredCommandMapper configuredCommandMapper;
    private final PermissionHandler permissionHandler;

    public CommandDetectionListener(BukkitUtils bukkitUtils, ActionService actionService, ConfiguredCommandMapper configuredCommandMapper, PermissionHandler permissionHandler) {
        this.bukkitUtils = bukkitUtils;
        this.actionService = actionService;
        this.configuredCommandMapper = configuredCommandMapper;
        this.permissionHandler = permissionHandler;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (this.permissionHandler.has(player, this.permissionCommandDetectionBypass)) {
            return;
        }
        String command = event.getMessage().toLowerCase();
        for (CommandDetectionGroupConfiguration groupConfig : this.commandsToDetect) {
            if (!groupConfig.commands.stream().anyMatch(prefix -> command.startsWith("/" + prefix))) continue;
            this.executeActions(player, groupConfig.actions, command);
            BukkitUtils.sendEvent(new CommandDetectedEvent(player, event.getMessage(), event.getPlayer().getWorld(), System.currentTimeMillis()));
        }
    }

    private void executeActions(Player player, List<ConfiguredCommand> commands, String detectedCommand) {
        if (commands.isEmpty()) {
            return;
        }
        this.bukkitUtils.runTaskAsync(() -> {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("%player%", player.getName());
            placeholders.put("%command%", detectedCommand);
            HashMap<String, OfflinePlayer> targets = new HashMap<String, OfflinePlayer>();
            targets.put("player", (OfflinePlayer)player);
            this.actionService.createCommands(this.configuredCommandMapper.toCreateRequests(commands, placeholders, targets, new ArrayList<ActionFilter>()));
        });
    }
}

