/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.chatchannels.bungee;

import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.bungee.BungeeClient;
import net.shortninja.staffplus.core.domain.chatchannels.bungee.dto.ChatChannelBungeeDto;
import net.shortninja.staffplus.core.domain.chatchannels.bungee.dto.ChatChannelCreatedBungeeDto;
import net.shortninja.staffplus.core.domain.chatchannels.bungee.dto.ChatChannelMessageBungeeDto;
import net.shortninja.staffplus.core.domain.chatchannels.bungee.dto.ChatChannelPlayerJoinedBungeeDto;
import net.shortninja.staffplus.core.domain.chatchannels.bungee.dto.ChatChannelPlayerLeftBungeeDto;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfig;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfiguration;
import net.shortninja.staffplusplus.chatchannels.ChatChannelClosedEvent;
import net.shortninja.staffplusplus.chatchannels.ChatChannelCreatedEvent;
import net.shortninja.staffplusplus.chatchannels.ChatChannelMessageSendEvent;
import net.shortninja.staffplusplus.chatchannels.ChatChannelPlayerJoinedEvent;
import net.shortninja.staffplusplus.chatchannels.ChatChannelPlayerLeftEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class ChatChannelBungeeSender
implements Listener {
    private final BungeeClient bungeeClient;
    private final ServerSyncConfiguration serverSyncConfiguration;

    public ChatChannelBungeeSender(BungeeClient bungeeClient, ServerSyncConfiguration serverSyncConfiguration) {
        this.bungeeClient = bungeeClient;
        this.serverSyncConfiguration = serverSyncConfiguration;
    }

    @EventHandler
    public void onChat(ChatChannelMessageSendEvent chatChannelMessageSendEvent) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Player player = (Player)Bukkit.getOnlinePlayers().iterator().next();
        ServerSyncConfig serverSyncConfig = this.serverSyncConfiguration.getForChatChannelType(chatChannelMessageSendEvent.getChannel().getType());
        this.bungeeClient.sendMessage(player, "staffplusplus.chatchannels.message-send", (Object)new ChatChannelMessageBungeeDto(chatChannelMessageSendEvent.getMessage(), chatChannelMessageSendEvent), serverSyncConfig);
    }

    @EventHandler
    public void onChannelCreated(ChatChannelCreatedEvent chatChannelCreatedEvent) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Player player = (Player)Bukkit.getOnlinePlayers().iterator().next();
        ServerSyncConfig serverSyncConfig = this.serverSyncConfiguration.getForChatChannelType(chatChannelCreatedEvent.getChannel().getType());
        this.bungeeClient.sendMessage(player, "staffplusplus.chatchannels.created", (Object)new ChatChannelCreatedBungeeDto(chatChannelCreatedEvent.getOpeningMessage(), chatChannelCreatedEvent), serverSyncConfig);
    }

    @EventHandler
    public void onChannelClosed(ChatChannelClosedEvent chatChannelClosedEvent) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Player player = (Player)Bukkit.getOnlinePlayers().iterator().next();
        ServerSyncConfig serverSyncConfig = this.serverSyncConfiguration.getForChatChannelType(chatChannelClosedEvent.getChannel().getType());
        this.bungeeClient.sendMessage(player, "staffplusplus.chatchannels.closed", (Object)new ChatChannelBungeeDto(chatChannelClosedEvent.getChannel()), serverSyncConfig);
    }

    @EventHandler
    public void onPlayerJoined(ChatChannelPlayerJoinedEvent chatChannelPlayerJoinedEvent) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Player player = (Player)Bukkit.getOnlinePlayers().iterator().next();
        ServerSyncConfig serverSyncConfig = this.serverSyncConfiguration.getForChatChannelType(chatChannelPlayerJoinedEvent.getChannel().getType());
        this.bungeeClient.sendMessage(player, "staffplusplus.chatchannels.player-joined", (Object)new ChatChannelPlayerJoinedBungeeDto(chatChannelPlayerJoinedEvent), serverSyncConfig);
    }

    @EventHandler
    public void onPlayerLeftChannel(ChatChannelPlayerLeftEvent chatChannelPlayerLeftEvent) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Player player = (Player)Bukkit.getOnlinePlayers().iterator().next();
        ServerSyncConfig serverSyncConfig = this.serverSyncConfiguration.getForChatChannelType(chatChannelPlayerLeftEvent.getChannel().getType());
        this.bungeeClient.sendMessage(player, "staffplusplus.chatchannels.player-left", (Object)new ChatChannelPlayerLeftBungeeDto(chatChannelPlayerLeftEvent), serverSyncConfig);
    }
}

