/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.chatchannels;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.chatchannels.ChatChannel;
import net.shortninja.staffplus.core.domain.chatchannels.ChatChannelRepository;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfig;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfiguration;
import net.shortninja.staffplusplus.chatchannels.ChatChannelClosedEvent;
import net.shortninja.staffplusplus.chatchannels.ChatChannelCreatedEvent;
import net.shortninja.staffplusplus.chatchannels.ChatChannelMessageSendEvent;
import net.shortninja.staffplusplus.chatchannels.ChatChannelPlayerJoinedEvent;
import net.shortninja.staffplusplus.chatchannels.ChatChannelPlayerLeftEvent;
import net.shortninja.staffplusplus.chatchannels.ChatChannelType;
import net.shortninja.staffplusplus.session.SppInteractor;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.entity.Player;

@IocBean
public class ChatChannelService {
    private final ChatChannelRepository chatChannelRepository;
    private final Options options;
    private final ServerSyncConfiguration serverSyncConfiguration;
    private List<ChatChannel> CHAT_CHANNELS_CACHE;

    public ChatChannelService(ChatChannelRepository chatChannelRepository, Options options, BukkitUtils bukkitUtils, ServerSyncConfiguration serverSyncConfiguration) {
        this.chatChannelRepository = chatChannelRepository;
        this.options = options;
        this.serverSyncConfiguration = serverSyncConfiguration;
        bukkitUtils.runTaskAsync(() -> {
            this.CHAT_CHANNELS_CACHE = chatChannelRepository.findAll();
        });
    }

    public void sendOnChannel(SppInteractor sender, String channelId, String message, ChatChannelType type) {
        ChatChannel channel = this.chatChannelRepository.findChatChannel(channelId, type, this.getSyncConfig(type)).orElseThrow(() -> new BusinessException("&cChat channel not found"));
        if (!channel.hasMember(sender)) {
            throw new BusinessException("&cYou are not a member of this channel");
        }
        BukkitUtils.sendEvent(new ChatChannelMessageSendEvent(sender, message, channel));
    }

    public void closeChannel(String channelId, ChatChannelType type) {
        ChatChannel chatChannel = this.chatChannelRepository.findChatChannel(channelId, type, this.getSyncConfig(type)).orElseThrow(() -> new BusinessException("&cChat channel not found"));
        this.chatChannelRepository.delete(chatChannel.getId());
        this.CHAT_CHANNELS_CACHE.removeIf(c -> c.getId() == chatChannel.getId());
        BukkitUtils.sendEvent(new ChatChannelClosedEvent(chatChannel));
    }

    public void create(String channelId, String chatChannelPrefix, String chatChannelLine, String openingMessage, Set<UUID> members, ChatChannelType type) {
        Optional<ChatChannel> existingChannel = this.chatChannelRepository.findChatChannel(channelId, type, this.getSyncConfig(type));
        if (existingChannel.isPresent()) {
            throw new BusinessException("&cCannot open chat channel. This channel has already been opened");
        }
        ChatChannel channel = new ChatChannel(chatChannelPrefix, chatChannelLine, channelId, members, type, this.options.serverName);
        this.chatChannelRepository.save(channel);
        this.updateCache(channel);
        BukkitUtils.sendEvent(new ChatChannelCreatedEvent(channel, openingMessage));
    }

    public List<String> getAllChannelNames() {
        return this.CHAT_CHANNELS_CACHE.stream().map(ChatChannel::getName).collect(Collectors.toList());
    }

    public void joinChannel(SppPlayer player, String channelId, ChatChannelType type) {
        ChatChannel chatChannel = this.chatChannelRepository.findChatChannel(channelId, type, this.getSyncConfig(type)).orElseThrow(() -> new BusinessException("&cChat channel not found"));
        if (chatChannel.hasMember(player)) {
            throw new BusinessException("&cYou are already a member of this channel");
        }
        chatChannel.addMember(player.getId());
        this.chatChannelRepository.addMember(chatChannel, player);
        this.updateCache(chatChannel);
        BukkitUtils.sendEvent(new ChatChannelPlayerJoinedEvent(player, chatChannel));
    }

    public void leaveChannel(SppPlayer player, String channelId, ChatChannelType type) {
        ChatChannel chatChannel = this.chatChannelRepository.findChatChannel(channelId, type, this.getSyncConfig(type)).orElseThrow(() -> new BusinessException("&cChat channel not found"));
        if (!chatChannel.hasMember(player)) {
            throw new BusinessException("&cYou are not a member of this channel");
        }
        chatChannel.removeMember(player.getId());
        this.chatChannelRepository.removeMember(chatChannel, player);
        this.updateCache(chatChannel);
        BukkitUtils.sendEvent(new ChatChannelPlayerLeftEvent(player, chatChannel));
    }

    public List<String> getMyChannelIds(Player player, ChatChannelType type) {
        return this.CHAT_CHANNELS_CACHE.stream().filter(c -> c.getType() == type).filter(c -> c.getMembers().contains(player.getUniqueId())).map(ChatChannel::getChannelId).collect(Collectors.toList());
    }

    public List<String> getAllChannelIds(ChatChannelType type) {
        return this.CHAT_CHANNELS_CACHE.stream().filter(c -> c.getType() == type).map(ChatChannel::getChannelId).collect(Collectors.toList());
    }

    private void updateCache(ChatChannel chatChannel) {
        this.CHAT_CHANNELS_CACHE.removeIf(c -> c.getId() == chatChannel.getId());
        this.CHAT_CHANNELS_CACHE.add(chatChannel);
    }

    public Optional<ChatChannel> findChannel(String channelId, ChatChannelType type) {
        return this.chatChannelRepository.findChatChannel(channelId, type, this.getSyncConfig(type));
    }

    private ServerSyncConfig getSyncConfig(ChatChannelType type) {
        return this.serverSyncConfiguration.getForChatChannelType(type);
    }
}

