/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.chatchannels;

import java.util.Set;
import java.util.UUID;
import net.shortninja.staffplusplus.chatchannels.ChatChannelType;
import net.shortninja.staffplusplus.chatchannels.IChatChannel;
import net.shortninja.staffplusplus.session.SppInteractor;

public class ChatChannel
implements IChatChannel {
    private int id;
    private final String prefix;
    private final String line;
    private final String name;
    private final String channelId;
    private Set<UUID> members;
    private final ChatChannelType type;
    private final String serverName;

    public ChatChannel(int id, String prefix, String line, String name, String channelId, ChatChannelType type, String serverName) {
        this.id = id;
        this.prefix = prefix;
        this.line = line;
        this.name = name;
        this.channelId = channelId;
        this.type = type;
        this.serverName = serverName;
    }

    public ChatChannel(String prefix, String line, String channelId, Set<UUID> members, ChatChannelType type, String serverName) {
        this.prefix = prefix;
        this.line = line;
        this.name = type.name() + "_" + channelId;
        this.channelId = channelId;
        this.members = members;
        this.type = type;
        this.serverName = serverName;
    }

    public void setMembers(Set<UUID> members) {
        this.members = members;
    }

    @Override
    public Set<UUID> getMembers() {
        return this.members;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public ChatChannelType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getLine() {
        return this.line;
    }

    public void addMember(UUID uniqueId) {
        this.members.add(uniqueId);
    }

    public void removeMember(UUID uniqueId) {
        this.members.remove(uniqueId);
    }

    public boolean hasMember(SppInteractor player) {
        return !player.isBukkitPlayer() || this.members.contains(player.getId());
    }
}

