/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.chat.mention.bungee;

import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitMessageListener;
import net.shortninja.staffplus.core.common.bungee.BungeeClient;
import net.shortninja.staffplus.core.domain.chat.mention.bungee.MentionBungeeDto;
import net.shortninja.staffplus.core.domain.chat.mention.bungee.PlayerMentionedBungeeEvent;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfig;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfigTransformer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.messaging.PluginMessageListener;

@IocBukkitMessageListener(channel="BungeeCord", conditionalOnProperty="isNotEmpty(alerts-module.mention-notify-bungee)")
public class MentionBungeeReceiver
implements PluginMessageListener {
    @ConfigProperty(value="alerts-module.mention-notify-bungee")
    @ConfigTransformer(value={ServerSyncConfigTransformer.class})
    private ServerSyncConfig syncServers;
    private final BungeeClient bungeeClient;

    public MentionBungeeReceiver(BungeeClient bungeeClient) {
        this.bungeeClient = bungeeClient;
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        Optional mentionBungeeDto = this.bungeeClient.handleReceived(channel, "staffplusplus.alerts.mention", message, MentionBungeeDto.class);
        if (mentionBungeeDto.isPresent() && this.syncServers.matchesServer(((MentionBungeeDto)mentionBungeeDto.get()).getServerName())) {
            Bukkit.getPluginManager().callEvent((Event)new PlayerMentionedBungeeEvent((MentionBungeeDto)mentionBungeeDto.get()));
        }
    }
}

