/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.chat.mention;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.mute.Mute;
import net.shortninja.staffplus.core.domain.staff.mute.MuteService;
import net.shortninja.staffplusplus.chat.PlayerMentionedEvent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@IocBukkitListener
public class PlayerMentionedChatListener
implements Listener {
    @ConfigProperty(value="permissions:mention-bypass")
    private String permissionMentionBypass;
    private final Options options;
    private final PlayerManager playerManager;
    private final BukkitUtils bukkitUtils;
    private final MuteService muteService;
    private final PermissionHandler permissionHandler;

    public PlayerMentionedChatListener(Options options, PlayerManager playerManager, BukkitUtils bukkitUtils, MuteService muteService, PermissionHandler permissionHandler) {
        this.options = options;
        this.playerManager = playerManager;
        this.bukkitUtils = bukkitUtils;
        this.muteService = muteService;
        this.permissionHandler = permissionHandler;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.permissionHandler.has(player, this.permissionMentionBypass)) {
            return;
        }
        String message = event.getMessage();
        this.notifyMentioned(player, message);
    }

    private void notifyMentioned(Player player, String message) {
        this.bukkitUtils.runTaskAsync(() -> {
            Optional<Mute> muteByMutedUuid = this.muteService.getMuteByMutedUuid(player.getUniqueId());
            if (!muteByMutedUuid.isPresent()) {
                this.getMentioned(message).stream().map(user -> new PlayerMentionedEvent(this.options.serverName, player, (OfflinePlayer)user, message)).forEach(BukkitUtils::sendEvent);
            }
        });
    }

    private List<OfflinePlayer> getMentioned(String message) {
        return this.playerManager.getOnAndOfflinePlayers().stream().filter(offlinePlayer -> message.toLowerCase().contains(offlinePlayer.getUsername().toLowerCase())).map(p -> Bukkit.getOfflinePlayer((UUID)p.getId())).collect(Collectors.toList());
    }
}

