/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.chat.bungee;

import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitMessageListener;
import net.shortninja.staffplus.core.common.bungee.BungeeClient;
import net.shortninja.staffplus.core.domain.chat.bungee.PhraseDetectedBungeeDto;
import net.shortninja.staffplus.core.domain.chat.bungee.PhraseDetectedBungeeEvent;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfig;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfigTransformer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.messaging.PluginMessageListener;

@IocBukkitMessageListener(channel="BungeeCord", conditionalOnProperty="isNotEmpty(alerts-module.chat-phrase-detection-bungee)")
public class PhraseDetectedBungeeReceiver
implements PluginMessageListener {
    @ConfigProperty(value="alerts-module.chat-phrase-detection-bungee")
    @ConfigTransformer(value={ServerSyncConfigTransformer.class})
    private ServerSyncConfig syncServers;
    private final BungeeClient bungeeClient;

    public PhraseDetectedBungeeReceiver(BungeeClient bungeeClient) {
        this.bungeeClient = bungeeClient;
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        Optional phraseDetectedBungeeDto = this.bungeeClient.handleReceived(channel, "staffplusplus.alerts.phrase-detection", message, PhraseDetectedBungeeDto.class);
        if (phraseDetectedBungeeDto.isPresent() && this.syncServers.matchesServer(((PhraseDetectedBungeeDto)phraseDetectedBungeeDto.get()).getServerName())) {
            Bukkit.getPluginManager().callEvent((Event)new PhraseDetectedBungeeEvent((PhraseDetectedBungeeDto)phraseDetectedBungeeDto.get()));
        }
    }
}

