/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.chat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.actions.ActionFilter;
import net.shortninja.staffplus.core.domain.actions.ActionService;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommand;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommandMapper;
import net.shortninja.staffplus.core.domain.chat.ChatInterceptor;
import net.shortninja.staffplus.core.domain.chat.configuration.ChatConfiguration;
import net.shortninja.staffplus.core.domain.chat.configuration.PhraseDetectionGroupConfiguration;
import net.shortninja.staffplusplus.chat.PhrasesDetectedEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@IocBean
@IocMultiProvider(value={ChatInterceptor.class})
public class PhraseDetectionChatInterceptor
implements ChatInterceptor {
    private final Options options;
    private final ChatConfiguration chatConfiguration;
    private final BukkitUtils bukkitUtils;
    private final ActionService actionService;
    private final ConfiguredCommandMapper configuredCommandMapper;
    private final PermissionHandler permission;
    @ConfigProperty(value="permissions:chat-phrase-detection-bypass")
    public String permissionChatPhraseDetectionBypass;

    public PhraseDetectionChatInterceptor(Options options, ChatConfiguration chatConfiguration, BukkitUtils bukkitUtils, ActionService actionService, ConfiguredCommandMapper configuredCommandMapper, PermissionHandler permission) {
        this.options = options;
        this.chatConfiguration = chatConfiguration;
        this.bukkitUtils = bukkitUtils;
        this.actionService = actionService;
        this.configuredCommandMapper = configuredCommandMapper;
        this.permission = permission;
    }

    @Override
    public boolean intercept(AsyncPlayerChatEvent event) {
        if (event.isCancelled() || this.permission.has(event.getPlayer(), this.permissionChatPhraseDetectionBypass)) {
            return false;
        }
        String message = event.getMessage();
        ArrayList<String> detectedPhrases = new ArrayList<String>();
        for (PhraseDetectionGroupConfiguration detectionPhrase : this.chatConfiguration.detectionPhrases) {
            List<String> phrases = detectionPhrase.phrases.stream().filter(phrase -> message.toLowerCase().contains(phrase.toLowerCase())).collect(Collectors.toList());
            if (!phrases.isEmpty()) {
                this.executeActions(event.getPlayer(), detectionPhrase.actions, phrases, message);
            }
            detectedPhrases.addAll(phrases);
        }
        if (!detectedPhrases.isEmpty()) {
            BukkitUtils.sendEvent(new PhrasesDetectedEvent(this.options.serverName, event.getPlayer(), event.getMessage(), detectedPhrases));
        }
        return false;
    }

    private void executeActions(Player player, List<ConfiguredCommand> commands, List<String> detectedPhrases, String message) {
        if (commands.isEmpty()) {
            return;
        }
        this.bukkitUtils.runTaskAsync(() -> {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("%player%", player.getName());
            placeholders.put("%phrases%", String.join((CharSequence)",", detectedPhrases));
            placeholders.put("%message%", message);
            HashMap<String, OfflinePlayer> targets = new HashMap<String, OfflinePlayer>();
            targets.put("player", (OfflinePlayer)player);
            this.actionService.createCommands(this.configuredCommandMapper.toCreateRequests(commands, placeholders, targets, new ArrayList<ActionFilter>()));
        });
    }

    @Override
    public int getPriority() {
        return 7;
    }
}

