/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.chat;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.domain.chat.ChatHandler;
import net.shortninja.staffplus.core.domain.chat.ChatInterceptor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@IocBean
@IocMultiProvider(value={ChatInterceptor.class})
public class GeneralChatInterceptor
implements ChatInterceptor {
    private final ChatHandler chatHandler;
    private final Messages messages;

    public GeneralChatInterceptor(ChatHandler chatHandler, Messages messages) {
        this.chatHandler = chatHandler;
        this.messages = messages;
    }

    @Override
    public boolean intercept(AsyncPlayerChatEvent event) {
        if (!this.chatHandler.canChat(event.getPlayer())) {
            this.messages.send((CommandSender)event.getPlayer(), this.messages.chattingFast, this.messages.prefixGeneral);
            return true;
        }
        if (!this.chatHandler.isChatEnabled(event.getPlayer())) {
            this.messages.send((CommandSender)event.getPlayer(), this.messages.chatPrevented, this.messages.prefixGeneral);
            return true;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 5;
    }
}

