/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.chat;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.chat.configuration.ChatConfiguration;
import org.bukkit.entity.Player;

@IocBean
public class ChatHandler {
    @ConfigProperty(value="permissions:chat-toggle")
    private String permissionChatToggle;
    @ConfigProperty(value="permissions:chat-slow")
    private String permissionChatSlow;
    private static final Map<UUID, Long> userChatTimes = new HashMap<UUID, Long>();
    private final PermissionHandler permission;
    private final ChatConfiguration chatConfiguration;
    private final Messages messages;
    private boolean isChatEnabled = true;
    private long chatSlowLength = 0L;
    private long chatSlowStart = 0L;

    public ChatHandler(PermissionHandler permission, ChatConfiguration chatConfiguration, Messages messages) {
        this.permission = permission;
        this.chatConfiguration = chatConfiguration;
        this.messages = messages;
    }

    public boolean isChatEnabled() {
        return this.isChatEnabled;
    }

    public boolean isChatEnabled(Player player) {
        return this.isChatEnabled || this.permission.has(player, this.permissionChatToggle);
    }

    public boolean canChat(Player player) {
        boolean canChat = true;
        if (this.chatSlowLength > 0L && !this.permission.has(player, this.permissionChatSlow)) {
            long lastChat;
            UUID uuid = player.getUniqueId();
            long now = System.currentTimeMillis();
            long l = lastChat = userChatTimes.containsKey(uuid) ? userChatTimes.get(uuid) : 0L;
            if (now - this.chatSlowStart >= this.chatSlowLength) {
                this.chatSlowLength = 0L;
                this.chatSlowStart = 0L;
                userChatTimes.clear();
            } else if ((now - lastChat) / 1000L <= (long)this.chatConfiguration.chatSlow) {
                canChat = false;
            } else {
                userChatTimes.put(uuid, now);
            }
        }
        return canChat;
    }

    public void setChatEnabled(String name, boolean isChatEnabled) {
        String status = isChatEnabled ? "enabled" : "disabled";
        this.messages.sendGlobalMessage(this.messages.chatToggled.replace("%status%", status).replace("%player%", name), this.messages.prefixGeneral);
        this.isChatEnabled = isChatEnabled;
    }

    public void setChatSlow(String name, int time) {
        this.chatSlowLength = (long)time * 1000L;
        this.chatSlowStart = System.currentTimeMillis();
        this.messages.sendGlobalMessage(this.messages.chatSlowed.replace("%seconds%", Integer.toString(time)).replace("%player%", name), this.messages.prefixGeneral);
    }

    public void clearChat(String name) {
        for (int i = 0; i < this.chatConfiguration.chatLines; ++i) {
            this.messages.sendGlobalMessage(this.messages.chatClearLine, "");
        }
        this.messages.sendGlobalMessage(this.messages.chatCleared.replace("%player%", name), this.messages.prefixGeneral);
    }
}

