/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.chat;

import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.chat.ChatHandler;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:chat", permissions={"permissions:chat-clear", "permissions:chat-toggle", "permissions:chat-slow"}, description="Executes the given chat management action.", usage="[clear | toggle | slow] {enable | disable | time}")
@IocBean(conditionalOnProperty="chat-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class ChatCmd
extends AbstractCmd {
    private final ChatHandler chatHandler;
    private final PermissionHandler permissionHandler;
    @ConfigProperty(value="permissions:chat-clear")
    private String permissionChatClear;
    @ConfigProperty(value="permissions:chat-toggle")
    private String permissionChatToggle;
    @ConfigProperty(value="permissions:chat-slow")
    private String permissionChatSlow;

    public ChatCmd(PermissionHandler permissionHandler, Messages messages, ChatHandler chatHandler, CommandService commandService) {
        super(messages, permissionHandler, commandService);
        this.chatHandler = chatHandler;
        this.permissionHandler = permissionHandler;
    }

    @Override
    public boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer targetPlayer, Map<String, String> optionalParameters) {
        if (args.length >= 2 && sender.isOp()) {
            this.handleChatArgument(sender, args[0], args[1], false);
        } else if (args.length == 1) {
            this.handleChatArgument(sender, args[0], "", true);
        } else {
            this.sendHelp(sender);
        }
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 1;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.empty();
    }

    private void handleChatArgument(CommandSender sender, String argument, String option, boolean shouldCheckPermission) {
        String name = sender instanceof Player ? sender.getName() : "Console";
        switch (argument.toLowerCase()) {
            case "clear": {
                if (!shouldCheckPermission || this.permissionHandler.has(sender, this.permissionChatClear)) {
                    this.chatHandler.clearChat(name);
                    break;
                }
                this.messages.send(sender, this.messages.noPermission, this.messages.prefixGeneral);
                break;
            }
            case "toggle": {
                if (!shouldCheckPermission || this.permissionHandler.has(sender, this.permissionChatToggle)) {
                    this.chatHandler.setChatEnabled(name, option.isEmpty() ? !this.chatHandler.isChatEnabled() : Boolean.parseBoolean(option));
                    break;
                }
                this.messages.send(sender, this.messages.noPermission, this.messages.prefixGeneral);
                break;
            }
            case "slow": {
                if (!shouldCheckPermission || this.permissionHandler.has(sender, this.permissionChatSlow)) {
                    if (JavaUtils.isInteger(option)) {
                        this.chatHandler.setChatSlow(name, Integer.parseInt(option));
                        break;
                    }
                    this.messages.send(sender, this.messages.invalidArguments.replace("%usage%", this.getName() + " &7" + this.getUsage()), this.messages.prefixGeneral);
                    break;
                }
                this.messages.send(sender, this.messages.noPermission, this.messages.prefixGeneral);
                break;
            }
            default: {
                this.messages.send(sender, this.messages.invalidArguments.replace("%usage%", this.getName() + " &7" + this.getUsage()), this.messages.prefixGeneral);
            }
        }
    }

    private void sendHelp(CommandSender sender) {
        this.messages.send(sender, "&7" + this.messages.LONG_LINE, "");
        this.messages.send(sender, "&b/" + this.getName() + " &7" + this.getUsage(), this.messages.prefixGeneral);
        this.messages.send(sender, "&7" + this.messages.LONG_LINE, "");
    }
}

