/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.blacklist.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.IProtocolService;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.blacklist.BlacklistService;
import net.shortninja.staffplusplus.blacklist.BlacklistCensoredEvent;
import net.shortninja.staffplusplus.blacklist.BlacklistType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@IocBukkitListener(conditionalOnProperty="blacklist-module.enabled=true && blacklist-module.censor-chat=true")
public class BlacklistChatListener
implements Listener {
    @ConfigProperty(value="permissions:blacklist")
    private String permissionBlacklist;
    @ConfigProperty(value="blacklist-module.hoverable")
    private boolean hoverable;
    private final BlacklistService blacklistService;
    private final PermissionHandler permission;
    private final IProtocolService protocolService;
    private final Options options;
    private final Messages messages;

    public BlacklistChatListener(BlacklistService blacklistService, PermissionHandler permission, IProtocolService protocolService, Options options, Messages messages) {
        this.blacklistService = blacklistService;
        this.permission = permission;
        this.protocolService = protocolService;
        this.options = options;
        this.messages = messages;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.permission.has(player, this.permissionBlacklist)) {
            return;
        }
        String originalMessage = event.getMessage();
        String censoredMessage = this.blacklistService.censorMessage(originalMessage);
        event.setMessage(censoredMessage);
        if (!originalMessage.equals(censoredMessage)) {
            this.setHoverableMessage(player, event, originalMessage, censoredMessage);
            BukkitUtils.sendEvent(new BlacklistCensoredEvent(this.options.serverName, player, censoredMessage, originalMessage, BlacklistType.CHAT));
        }
    }

    private void setHoverableMessage(Player player, AsyncPlayerChatEvent event, String originalMessage, String censoredMessage) {
        if (this.hoverable) {
            List<Player> validPlayers = Bukkit.getOnlinePlayers().stream().filter(p -> this.permission.has((Player)p, this.permissionBlacklist)).collect(Collectors.toList());
            validPlayers.forEach(event.getRecipients()::remove);
            ArrayList<Player> staffPlayers = new ArrayList<Player>(validPlayers);
            this.messages.send(staffPlayers, this.messages.blacklistChatFormat.replace("%player%", player.getName()).replace("%message%", "[tooltip|" + censoredMessage + "|&b" + originalMessage + "]"), "");
        }
    }
}

