/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.blacklist.listeners;

import java.util.ArrayList;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.blacklist.BlacklistService;
import net.shortninja.staffplusplus.blacklist.BlacklistCensoredEvent;
import net.shortninja.staffplusplus.blacklist.BlacklistType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.inventory.meta.BookMeta;

@IocBukkitListener(conditionalOnProperty="blacklist-module.enabled=true && blacklist-module.censor-book=true")
public class BlacklistBookListener
implements Listener {
    @ConfigProperty(value="permissions:blacklist")
    private String permissionBlacklist;
    private final BlacklistService blacklistService;
    private final PermissionHandler permission;
    private final Options options;

    public BlacklistBookListener(BlacklistService blacklistService, PermissionHandler permission, Options options) {
        this.blacklistService = blacklistService;
        this.permission = permission;
        this.options = options;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void bookListener(PlayerEditBookEvent event) {
        Player player = event.getPlayer();
        if (this.permission.has(player, this.permissionBlacklist)) {
            return;
        }
        ArrayList<String> originalText = new ArrayList<String>();
        ArrayList<String> censoredText = new ArrayList<String>();
        boolean censored = false;
        BookMeta newBookMeta = event.getNewBookMeta();
        String originalTitle = newBookMeta.getTitle();
        if (originalTitle != null) {
            String censoredTitle = this.blacklistService.censorMessage(originalTitle);
            newBookMeta.setTitle(censoredTitle);
            originalText.add(originalTitle);
            censoredText.add(censoredTitle);
            censored = !originalTitle.equals(censoredTitle);
        }
        for (int i = 1; i <= newBookMeta.getPages().size(); ++i) {
            String originalPage = newBookMeta.getPage(i);
            String censoredPage = this.blacklistService.censorMessage(originalPage);
            newBookMeta.setPage(i, censoredPage);
            originalText.add(originalPage);
            censoredText.add(censoredPage);
            censored = censored || !originalPage.equals(censoredPage);
        }
        if (censored) {
            event.setNewBookMeta(newBookMeta);
            BukkitUtils.sendEvent(new BlacklistCensoredEvent(this.options.serverName, player, String.join((CharSequence)" ", censoredText), String.join((CharSequence)" ", originalText), BlacklistType.BOOK));
        }
    }
}

