/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.blacklist.censors;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.domain.blacklist.BlackListConfiguration;
import net.shortninja.staffplus.core.domain.blacklist.censors.BlacklistCensor;

@IocBean
@IocMultiProvider(value={BlacklistCensor.class})
public class IllegalWordsBlacklistCensor
implements BlacklistCensor {
    @ConfigProperty(value="blacklist-module.character")
    private String censorCharacter;
    @ConfigProperty(value="blacklist-module.merging")
    private boolean merging;
    private final BlackListConfiguration blackListConfiguration;

    public IllegalWordsBlacklistCensor(BlackListConfiguration blackListConfiguration) {
        this.blackListConfiguration = blackListConfiguration;
    }

    @Override
    public String censor(String message) {
        List censoredWords = Arrays.stream(message.split(" ")).filter(w -> !this.isBypassable((String)w)).filter(this::wordMatched).collect(Collectors.toList());
        String newMessage = message;
        for (String censoredWord : censoredWords) {
            newMessage = this.censor(newMessage, censoredWord, this.censorCharacter);
        }
        return newMessage;
    }

    private boolean wordMatched(String word) {
        String wordLower = word.toLowerCase();
        if (this.merging) {
            return this.blackListConfiguration.getCensoredWords().stream().anyMatch(wordLower::contains);
        }
        return this.blackListConfiguration.getCensoredWords().stream().anyMatch(wordLower::equalsIgnoreCase);
    }

    private boolean isBypassable(String word) {
        return this.blackListConfiguration.getAllowedWords().stream().anyMatch(word::equalsIgnoreCase);
    }
}

