/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.blacklist.censors;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.domain.blacklist.BlackListConfiguration;
import net.shortninja.staffplus.core.domain.blacklist.censors.BlacklistCensor;

@IocBean
@IocMultiProvider(value={BlacklistCensor.class})
public class DomainBlacklistCensor
implements BlacklistCensor {
    @ConfigProperty(value="blacklist-module.character")
    private String censorCharacter;
    private final BlackListConfiguration blackListConfiguration;

    public DomainBlacklistCensor(BlackListConfiguration blackListConfiguration) {
        this.blackListConfiguration = blackListConfiguration;
    }

    @Override
    public String censor(String message) {
        String newMessage = this.replacePeriods(message);
        String[] words = newMessage.split(Pattern.quote("."));
        List wordsToCensor = Arrays.stream(words).filter(this::containsDomain).collect(Collectors.toList());
        for (String word : wordsToCensor) {
            newMessage = this.censor(newMessage, word, this.censorCharacter);
        }
        return newMessage;
    }

    private String replacePeriods(String newMessage) {
        for (String period : this.blackListConfiguration.getPeriods()) {
            newMessage = newMessage.replace(period, ".");
        }
        return newMessage;
    }

    private boolean containsDomain(String word) {
        return this.blackListConfiguration.getCensoredDomains().stream().anyMatch(word::equalsIgnoreCase);
    }
}

