/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.blacklist.bungee;

import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitMessageListener;
import net.shortninja.staffplus.core.common.bungee.BungeeClient;
import net.shortninja.staffplus.core.domain.blacklist.bungee.ChatMessageCensoredBungeeDto;
import net.shortninja.staffplus.core.domain.blacklist.bungee.ChatMessageCensoredBungeeEvent;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfig;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfigTransformer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.messaging.PluginMessageListener;

@IocBukkitMessageListener(channel="BungeeCord", conditionalOnProperty="isNotEmpty(alerts-module.blacklist-notify-bungee)")
public class ChatMessageCensoredBungeeReceiver
implements PluginMessageListener {
    @ConfigProperty(value="alerts-module.blacklist-notify-bungee")
    @ConfigTransformer(value={ServerSyncConfigTransformer.class})
    private ServerSyncConfig syncServers;
    private final BungeeClient bungeeClient;

    public ChatMessageCensoredBungeeReceiver(BungeeClient bungeeClient) {
        this.bungeeClient = bungeeClient;
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        Optional chatMessageCensoredBungeeDto = this.bungeeClient.handleReceived(channel, "staffplusplus.alerts.blacklist", message, ChatMessageCensoredBungeeDto.class);
        if (chatMessageCensoredBungeeDto.isPresent() && this.syncServers.matchesServer(((ChatMessageCensoredBungeeDto)chatMessageCensoredBungeeDto.get()).getServerName())) {
            Bukkit.getPluginManager().callEvent((Event)new ChatMessageCensoredBungeeEvent((ChatMessageCensoredBungeeDto)chatMessageCensoredBungeeDto.get()));
        }
    }
}

