/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.actions.delayedactions;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.common.cmd.arguments.ArgumentType;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.actions.ActionRunStrategy;
import net.shortninja.staffplus.core.domain.actions.ActionService;
import net.shortninja.staffplus.core.domain.actions.CreateStoredCommandRequest;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;

@IocBean
public class DelayArgumentExecutor {
    private final Messages messages;
    private final PlayerManager playerManager;
    private final Options options;
    private final BukkitUtils bukkitUtils;
    private final ActionService actionService;

    public DelayArgumentExecutor(Messages messages, PlayerManager playerManager, Options options, BukkitUtils bukkitUtils, ActionService actionService) {
        this.messages = messages;
        this.playerManager = playerManager;
        this.options = options;
        this.bukkitUtils = bukkitUtils;
        this.actionService = actionService;
    }

    public boolean execute(CommandSender commandSender, String playerName, String command) {
        Optional<SppPlayer> player = this.playerManager.getOnOrOfflinePlayer(playerName);
        if (!player.isPresent()) {
            throw new BusinessException("&CCannot delay the command. No user found on this server with name: [" + playerName + "]", this.messages.prefixGeneral);
        }
        this.bukkitUtils.runTaskAsync(() -> this.actionService.createCommand(CreateStoredCommandRequest.CreateStoredCommandRequestBuilder.commandBuilder().serverName(this.options.serverName).executor(Constants.CONSOLE_UUID).executorRunStrategy(ActionRunStrategy.ONLINE).target(((SppPlayer)player.get()).getOfflinePlayer()).targetRunStrategy(ActionRunStrategy.DELAY).command(command).build()));
        this.messages.send(commandSender, "Your command has been delayed and will be executed next time [" + playerName + "] joins the server", this.messages.prefixGeneral);
        return true;
    }

    public ArgumentType getType() {
        return ArgumentType.DELAY;
    }

    public List<String> complete() {
        return Arrays.asList(this.getType().getPrefix());
    }
}

