/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.actions.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.exceptions.ConfigurationException;
import net.shortninja.staffplus.core.domain.actions.ActionFilter;
import net.shortninja.staffplus.core.domain.actions.CreateStoredCommandRequest;
import net.shortninja.staffplus.core.domain.actions.PermissionActionFilter;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommand;
import net.shortninja.staffplusplus.Actionable;
import org.bukkit.OfflinePlayer;

@IocBean
public class ConfiguredCommandMapper {
    private final Options options;
    private final PermissionActionFilter permissionActionFilter;

    public ConfiguredCommandMapper(Options options, PermissionActionFilter permissionActionFilter) {
        this.options = options;
        this.permissionActionFilter = permissionActionFilter;
    }

    public List<CreateStoredCommandRequest> toCreateRequests(List<ConfiguredCommand> configuredCommands, Map<String, String> placeholders, Map<String, OfflinePlayer> targets, List<ActionFilter> actionFilters) {
        return this.toCreateRequests(null, configuredCommands, placeholders, targets, actionFilters);
    }

    public List<CreateStoredCommandRequest> toCreateRequests(Actionable actionable, List<ConfiguredCommand> configuredCommands, Map<String, String> placeholders, Map<String, OfflinePlayer> targets, List<ActionFilter> actionFilters) {
        ArrayList<ActionFilter> filters = new ArrayList<ActionFilter>(actionFilters);
        filters.add(this.permissionActionFilter);
        ArrayList<CreateStoredCommandRequest> list = new ArrayList<CreateStoredCommandRequest>();
        for (ConfiguredCommand c : configuredCommands) {
            CreateStoredCommandRequest createStoredCommandRequest = this.toCreateRequest(actionable, c, placeholders, targets);
            if (!filters.stream().allMatch(a -> a.isValidAction(createStoredCommandRequest, c.getFilters()))) continue;
            list.add(createStoredCommandRequest);
        }
        return list;
    }

    public CreateStoredCommandRequest toCreateRequest(Actionable actionable, ConfiguredCommand c, Map<String, String> placeholders, Map<String, OfflinePlayer> targets) {
        UUID executorUuid;
        OfflinePlayer target = this.getTarget(c, targets);
        if (c.getExecutor().equalsIgnoreCase("console")) {
            executorUuid = Constants.CONSOLE_UUID;
            placeholders.put("%executor%", "console");
        } else {
            OfflinePlayer executorPlayer = this.getExecutor(c, targets);
            executorUuid = executorPlayer.getUniqueId();
            placeholders.put("%executor%", executorPlayer.getName());
        }
        if (target != null) {
            placeholders.put("%target%", target.getName());
        }
        CreateStoredCommandRequest.CreateStoredCommandRequestBuilder builder = CreateStoredCommandRequest.CreateStoredCommandRequestBuilder.commandBuilder().command(JavaUtils.replacePlaceholders(c.getCommand(), placeholders)).executor(executorUuid).executorRunStrategy(c.getExecutorRunStrategy()).target(target).targetRunStrategy(c.getTargetRunStrategy().orElse(null)).serverName(this.options.serverName);
        if (actionable != null) {
            builder.actionableId(actionable.getId()).actionableType(actionable.getActionableType());
        }
        if (c.getRollbackCommand().isPresent()) {
            builder.rollbackCommand(this.toCreateRequest(actionable, c.getRollbackCommand().get(), placeholders, targets));
        }
        return builder.build();
    }

    private OfflinePlayer getExecutor(ConfiguredCommand configuredCommand, Map<String, OfflinePlayer> targets) {
        String key = configuredCommand.getExecutor();
        if (!targets.containsKey(key)) {
            throw new ConfigurationException("No executor [" + key + "] know for this command configuration");
        }
        return targets.get(key);
    }

    private OfflinePlayer getTarget(ConfiguredCommand configuredCommand, Map<String, OfflinePlayer> targets) {
        if (!configuredCommand.getTarget().isPresent()) {
            return null;
        }
        String key = configuredCommand.getTarget().get();
        if (!targets.containsKey(key)) {
            throw new ConfigurationException("No target [" + key + "] know for this command configuration");
        }
        return targets.get(key);
    }
}

