/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.actions.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigEmbeddedObject;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.transformers.ToEnum;
import net.shortninja.staffplus.core.domain.actions.ActionRunStrategy;
import net.shortninja.staffplus.core.domain.actions.config.FiltersTransformer;

public class ConfiguredCommand {
    @ConfigProperty(value="command")
    private String command;
    @ConfigProperty(value="executor")
    private String executor = "console";
    @ConfigProperty(value="executor-run-strategy")
    @ConfigTransformer(value={ToEnum.class})
    private ActionRunStrategy executorRunStrategy = ActionRunStrategy.ONLINE;
    @ConfigProperty(value="target")
    private String target;
    @ConfigProperty(value="target-run-strategy")
    @ConfigTransformer(value={ToEnum.class})
    private ActionRunStrategy targetRunStrategy;
    @ConfigProperty(value="filters")
    @ConfigTransformer(value={FiltersTransformer.class})
    private Map<String, String> filters = new HashMap<String, String>();
    @ConfigProperty(value="rollback-command")
    @ConfigEmbeddedObject(value=ConfiguredCommand.class)
    private ConfiguredCommand rollbackCommand;

    public ConfiguredCommand() {
    }

    public ConfiguredCommand(String command, String executor, ActionRunStrategy executorRunStrategy, String target, ActionRunStrategy targetRunStrategy, Map<String, String> filters, ConfiguredCommand rollbackCommand) {
        this.command = command;
        this.executor = executor;
        this.executorRunStrategy = executorRunStrategy;
        this.target = target;
        this.targetRunStrategy = targetRunStrategy;
        this.rollbackCommand = rollbackCommand;
        this.filters = new HashMap<String, String>();
        filters.forEach((k, v) -> this.filters.put(k.toLowerCase(), v.toLowerCase()));
    }

    public String getCommand() {
        return this.command;
    }

    public String getExecutor() {
        return this.executor;
    }

    public ActionRunStrategy getExecutorRunStrategy() {
        return this.executorRunStrategy;
    }

    public Optional<String> getTarget() {
        return Optional.ofNullable(this.target);
    }

    public Optional<ActionRunStrategy> getTargetRunStrategy() {
        return Optional.ofNullable(this.targetRunStrategy);
    }

    public Map<String, String> getFilters() {
        return this.filters;
    }

    public Optional<ConfiguredCommand> getRollbackCommand() {
        return Optional.ofNullable(this.rollbackCommand);
    }
}

