/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.actions;

import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.actions.ActionFilter;
import net.shortninja.staffplus.core.domain.actions.CreateStoredCommandRequest;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplusplus.session.SppPlayer;

@IocBean
public class PermissionActionFilter
implements ActionFilter {
    private static final String PERMISSION = "permission";
    private final PermissionHandler permissionHandler;
    private final PlayerManager playerManager;

    public PermissionActionFilter(PermissionHandler permissionHandler, PlayerManager playerManager) {
        this.permissionHandler = permissionHandler;
        this.playerManager = playerManager;
    }

    @Override
    public boolean isValidAction(CreateStoredCommandRequest createStoredCommandRequest, Map<String, String> filters) {
        if (filters.containsKey(PERMISSION)) {
            if (createStoredCommandRequest.getExecutor().equals(Constants.CONSOLE_UUID)) {
                return true;
            }
            Optional<SppPlayer> onlinePlayer = this.playerManager.getOnlinePlayer(createStoredCommandRequest.getExecutor());
            if (onlinePlayer.isPresent()) {
                String permission = filters.get(PERMISSION);
                return this.permissionHandler.has(onlinePlayer.get().getPlayer(), permission);
            }
        }
        return true;
    }
}

