/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.actions;

import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.domain.actions.ActionRunStrategy;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import org.bukkit.OfflinePlayer;

public class CreateStoredCommandRequest {
    private final UUID executor;
    private final ActionRunStrategy executorRunStrategy;
    private final OfflinePlayer target;
    private final ActionRunStrategy targetRunStrategy;
    private final String command;
    private final CreateStoredCommandRequest rollbackCommand;
    private final Integer actionableId;
    private final String actionableType;
    private final String serverName;

    public CreateStoredCommandRequest(UUID executor, ActionRunStrategy executorRunStrategy, OfflinePlayer target, ActionRunStrategy targetRunStrategy, String command, CreateStoredCommandRequest rollbackCommand, Integer actionableId, String actionableType, String serverName) {
        this.executor = executor;
        this.executorRunStrategy = executorRunStrategy;
        this.target = target;
        this.targetRunStrategy = targetRunStrategy;
        this.command = command;
        this.rollbackCommand = rollbackCommand;
        this.actionableId = actionableId;
        this.actionableType = actionableType;
        this.serverName = serverName;
    }

    public UUID getExecutor() {
        return this.executor;
    }

    public ActionRunStrategy getExecutorRunStrategy() {
        return this.executorRunStrategy;
    }

    public Optional<OfflinePlayer> getTarget() {
        return Optional.ofNullable(this.target);
    }

    public Optional<ActionRunStrategy> getTargetRunStrategy() {
        return Optional.ofNullable(this.targetRunStrategy);
    }

    public String getCommand() {
        return this.command;
    }

    public Optional<CreateStoredCommandRequest> getRollbackCommand() {
        return Optional.ofNullable(this.rollbackCommand);
    }

    public Optional<Integer> getActionableId() {
        return Optional.ofNullable(this.actionableId);
    }

    public Optional<String> getActionableType() {
        return Optional.ofNullable(this.actionableType);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void validate() {
        if (this.executor == null) {
            throw new BusinessException("Executor is mandatory");
        }
        if (this.executorRunStrategy == null) {
            throw new BusinessException("executorRunStrategy is mandatory");
        }
        if (this.target != null && this.targetRunStrategy == null) {
            throw new BusinessException("targetRunStrategy is mandatory when target filled in");
        }
        if (StringUtils.isBlank(this.command)) {
            throw new BusinessException("command is mandatory");
        }
        if (StringUtils.isBlank(this.serverName)) {
            throw new BusinessException("serverName is mandatory");
        }
        if (this.rollbackCommand != null) {
            this.rollbackCommand.validate();
        }
    }

    public static class CreateStoredCommandRequestBuilder {
        private UUID executor;
        private ActionRunStrategy executorRunStrategy;
        private OfflinePlayer target;
        private ActionRunStrategy targetRunStrategy;
        private String command;
        private CreateStoredCommandRequest rollbackCommand;
        private Integer actionableId;
        private String actionableType;
        private String serverName;

        public static CreateStoredCommandRequestBuilder commandBuilder() {
            return new CreateStoredCommandRequestBuilder();
        }

        public CreateStoredCommandRequestBuilder executor(UUID executor) {
            this.executor = executor;
            return this;
        }

        public CreateStoredCommandRequestBuilder executorRunStrategy(ActionRunStrategy executorRunStrategy) {
            this.executorRunStrategy = executorRunStrategy;
            return this;
        }

        public CreateStoredCommandRequestBuilder target(OfflinePlayer target) {
            this.target = target;
            return this;
        }

        public CreateStoredCommandRequestBuilder targetRunStrategy(ActionRunStrategy targetRunStrategy) {
            this.targetRunStrategy = targetRunStrategy;
            return this;
        }

        public CreateStoredCommandRequestBuilder command(String command) {
            this.command = command;
            return this;
        }

        public CreateStoredCommandRequestBuilder rollbackCommand(CreateStoredCommandRequest rollbackCommand) {
            this.rollbackCommand = rollbackCommand;
            return this;
        }

        public CreateStoredCommandRequestBuilder actionableId(Integer actionableId) {
            this.actionableId = actionableId;
            return this;
        }

        public CreateStoredCommandRequestBuilder actionableType(String actionableType) {
            this.actionableType = actionableType;
            return this;
        }

        public CreateStoredCommandRequestBuilder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public CreateStoredCommandRequest build() {
            return new CreateStoredCommandRequest(this.executor, this.executorRunStrategy, this.target, this.targetRunStrategy, this.command, this.rollbackCommand, this.actionableId, this.actionableType, this.serverName);
        }
    }
}

