/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.actions;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.actions.ActionRunStrategy;
import net.shortninja.staffplus.core.domain.actions.CommandExecutedEvent;
import net.shortninja.staffplus.core.domain.actions.CreateStoredCommandRequest;
import net.shortninja.staffplus.core.domain.actions.StoredCommandEntity;
import net.shortninja.staffplus.core.domain.actions.database.StoredCommandRepository;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplusplus.Actionable;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

@IocBean
public class ActionService {
    private final PlayerManager playerManager;
    private final StoredCommandRepository storedCommandRepository;
    private final Options options;

    public ActionService(PlayerManager playerManager, StoredCommandRepository storedCommandRepository, Options options) {
        this.playerManager = playerManager;
        this.storedCommandRepository = storedCommandRepository;
        this.options = options;
    }

    public List<StoredCommandEntity> createCommands(List<CreateStoredCommandRequest> commands) {
        return commands.stream().map(this::createCommand).filter(StoredCommandEntity::isExecuted).collect(Collectors.toList());
    }

    public StoredCommandEntity createCommand(CreateStoredCommandRequest request) {
        request.validate();
        StoredCommandEntity commandEntity = new StoredCommandEntity(request, this.isDelayed(request));
        int id = this.storedCommandRepository.saveCommand(commandEntity);
        commandEntity.setId(id);
        if (this.canExecute(commandEntity)) {
            this.executeCommand(commandEntity, id);
        }
        return commandEntity;
    }

    public void rollbackActionable(Actionable actionable) {
        Optional<SppPlayer> target = this.playerManager.getOnOrOfflinePlayer(actionable.getTargetUuid());
        if (!target.isPresent()) {
            return;
        }
        this.storedCommandRepository.getCommandsFor(actionable).stream().filter(a -> a.isExecuted() && a.isRollbackable() && !a.isRollbacked()).forEach(this::rollbackCommand);
    }

    public void rollbackCommand(StoredCommandEntity storedCommandEntity) {
        if (!storedCommandEntity.isRollbackable()) {
            throw new BusinessException("This command is not rollbackable");
        }
        if (storedCommandEntity.isRollbacked()) {
            throw new BusinessException("This command has already been rollbacked");
        }
        StoredCommandEntity rollbackCommand = storedCommandEntity.getRollbackCommand().get();
        boolean delayed = this.isDelayed(rollbackCommand);
        if (delayed) {
            this.storedCommandRepository.markDelayed(rollbackCommand.getId());
            return;
        }
        if (this.canExecute(rollbackCommand)) {
            this.executeCommand(rollbackCommand, rollbackCommand.getId());
        }
        this.markRollbacked(rollbackCommand.getId());
    }

    public void executeDelayed(StoredCommandEntity storedCommand) {
        if (this.canExecute(storedCommand)) {
            this.executeCommand(storedCommand, storedCommand.getId());
        }
    }

    private void executeCommand(StoredCommandEntity storedCommandEntity, Integer id) {
        ConsoleCommandSender executor = storedCommandEntity.getExecutorUuid().equals(Constants.CONSOLE_UUID) ? Bukkit.getConsoleSender() : this.playerManager.getOnlinePlayer(storedCommandEntity.getExecutorUuid()).get().getPlayer();
        this.storedCommandRepository.markExecuted(id);
        storedCommandEntity.setExecutionTimestamp(System.currentTimeMillis());
        BukkitUtils.sendEvent(new CommandExecutedEvent((CommandSender)executor, storedCommandEntity.getCommand()));
    }

    private boolean isDelayed(CreateStoredCommandRequest storedCommandEntity) {
        boolean executorDelayed = !storedCommandEntity.getExecutor().equals(Constants.CONSOLE_UUID) && storedCommandEntity.getExecutorRunStrategy() == ActionRunStrategy.DELAY && !this.playerManager.getOnlinePlayer(storedCommandEntity.getExecutor()).isPresent();
        boolean targetDelayed = storedCommandEntity.getTarget().isPresent() && storedCommandEntity.getTargetRunStrategy().orElse(null) == ActionRunStrategy.DELAY && !this.playerManager.getOnlinePlayer(storedCommandEntity.getTarget().get().getUniqueId()).isPresent();
        return executorDelayed || targetDelayed;
    }

    private boolean isDelayed(StoredCommandEntity storedCommandEntity) {
        boolean executorDelayed = !storedCommandEntity.getExecutorUuid().equals(Constants.CONSOLE_UUID) && storedCommandEntity.getExecutorRunStrategy() == ActionRunStrategy.DELAY && !this.playerManager.getOnlinePlayer(storedCommandEntity.getExecutorUuid()).isPresent();
        boolean targetDelayed = storedCommandEntity.getTargetUuid().isPresent() && storedCommandEntity.getTargetRunStrategy().orElse(null) == ActionRunStrategy.DELAY && !this.playerManager.getOnlinePlayer(storedCommandEntity.getTargetUuid().get()).isPresent();
        return executorDelayed || targetDelayed;
    }

    private boolean canExecute(StoredCommandEntity storedCommandEntity) {
        if (storedCommandEntity.getServerName().isPresent() && !storedCommandEntity.getServerName().get().equals(this.options.serverName)) {
            return false;
        }
        boolean executorOnline = storedCommandEntity.getExecutorUuid().equals(Constants.CONSOLE_UUID) || this.playerManager.getOnlinePlayer(storedCommandEntity.getExecutorUuid()).isPresent();
        boolean targetNotPresentOrOnline = !storedCommandEntity.getTargetUuid().isPresent() || this.playerManager.getOnlinePlayer(storedCommandEntity.getTargetUuid().get()).isPresent();
        return executorOnline && (targetNotPresentOrOnline || storedCommandEntity.getTargetRunStrategy().get() == ActionRunStrategy.ALWAYS);
    }

    public void markRollbacked(int executableActionId) {
        this.storedCommandRepository.markRollbacked(executableActionId);
    }

    public Collection<StoredCommandEntity> getActions(Actionable actionable) {
        return this.storedCommandRepository.getCommandsFor(actionable);
    }
}

