/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.utils;

import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

@IocBean
public class BukkitUtils {
    private final Messages messages;

    public BukkitUtils(Messages messages) {
        this.messages = messages;
    }

    public static void sendEvent(Event event) {
        if (StaffPlusPlus.get().isEnabled()) {
            Bukkit.getScheduler().runTask((Plugin)StaffPlusPlus.get(), () -> Bukkit.getPluginManager().callEvent(event));
        }
    }

    public static void sendEventOnThisTick(Event event) {
        if (StaffPlusPlus.get().isEnabled()) {
            Bukkit.getPluginManager().callEvent(event);
        }
    }

    public static void sendEventAsync(Event event) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)StaffPlusPlus.get(), () -> Bukkit.getPluginManager().callEvent(event));
    }

    public void runTaskAsync(CommandSender sender, Runnable runnable) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)StaffPlusPlus.get(), () -> {
            try {
                runnable.run();
            }
            catch (BusinessException e) {
                this.messages.send(sender, e.getMessage(), e.getPrefix());
            }
        });
    }

    public void runTaskLater(CommandSender sender, Runnable runnable) {
        Bukkit.getScheduler().runTaskLater((Plugin)StaffPlusPlus.get(), () -> {
            try {
                runnable.run();
            }
            catch (BusinessException e) {
                this.messages.send(sender, e.getMessage(), e.getPrefix());
            }
        }, 1L);
    }

    public void runTaskLater(Runnable runnable) {
        this.runTaskLater((CommandSender)Bukkit.getConsoleSender(), runnable);
    }

    public void runTaskAsync(Runnable runnable) {
        this.runTaskAsync((CommandSender)Bukkit.getConsoleSender(), runnable);
    }

    public static int getInventorySize(int amountOfItems) {
        int division = amountOfItems / 9;
        int rest = amountOfItems % 9;
        if (rest != 0) {
            return ++division * 9;
        }
        return amountOfItems;
    }

    public static String getIpFromPlayer(Player player) {
        return player.getAddress().getAddress().getHostAddress().replace("/", "");
    }
}

