/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.permissions;

import java.util.Arrays;
import java.util.Set;
import net.milkbowl.vault.permission.Permission;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.common.exceptions.ConfigurationException;
import net.shortninja.staffplus.core.common.exceptions.NoPermissionException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultPermissionHandler
implements PermissionHandler {
    private static Permission perms = null;
    private final Options options;

    public VaultPermissionHandler(Options options) {
        this.options = options;
        RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
        if (rsp == null) {
            throw new ConfigurationException("Vault plugin was not found. Please disable vault in the config or provide the vault plugin");
        }
        perms = (Permission)rsp.getProvider();
    }

    @Override
    public boolean has(Player player, String permission) {
        if (permission == null) {
            return true;
        }
        boolean hasPermission = false;
        if (player != null) {
            hasPermission = perms.has(player, permission);
        }
        return hasPermission;
    }

    @Override
    public boolean has(OfflinePlayer player, String permission) {
        if (permission == null) {
            return true;
        }
        boolean hasPermission = false;
        if (player != null) {
            World world = Bukkit.getWorlds().stream().filter(w -> w.getName().equalsIgnoreCase(this.options.mainWorld)).findFirst().orElse((World)Bukkit.getWorlds().get(0));
            hasPermission = perms.playerHas(world.getName(), player, permission);
        }
        return hasPermission;
    }

    @Override
    public boolean hasAny(CommandSender player, String ... permissions) {
        return Arrays.stream(permissions).anyMatch(permission -> this.has(player, (String)permission));
    }

    @Override
    public boolean hasAny(CommandSender player, Set<String> permissions) {
        return permissions.stream().anyMatch(permission -> this.has(player, (String)permission));
    }

    @Override
    public void validate(CommandSender player, String permission) {
        if (permission != null && !this.has(player, permission)) {
            throw new NoPermissionException();
        }
    }

    @Override
    public void validateAny(CommandSender player, Set<String> permissions) {
        if (!permissions.isEmpty() && !this.hasAny(player, permissions)) {
            throw new NoPermissionException();
        }
    }

    @Override
    public void validateAny(CommandSender player, String ... permissions) {
        if (permissions.length != 0 && !this.hasAny(player, permissions)) {
            throw new NoPermissionException();
        }
    }

    @Override
    public boolean hasOnly(Player player, String permission) {
        if (permission == null) {
            return true;
        }
        boolean hasPermission = false;
        if (player != null) {
            hasPermission = perms.has(player, permission);
        }
        return hasPermission;
    }

    @Override
    public boolean has(CommandSender sender, String permission) {
        if (permission == null) {
            return true;
        }
        return perms.has(sender, permission);
    }

    @Override
    public int getStaffCount() {
        int count = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.has(player, this.options.permissionMember)) continue;
            ++count;
        }
        return count;
    }
}

