/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.permissions;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.permissions.TubingPermissionService;
import net.shortninja.staffplus.core.common.exceptions.NoDurationPermissionException;
import net.shortninja.staffplus.core.common.exceptions.NoPermissionException;
import net.shortninja.staffplus.core.common.time.TimeUnitShort;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public interface PermissionHandler
extends TubingPermissionService {
    default public List<String> getPermissions(CommandSender player) {
        return player.getEffectivePermissions().stream().map(PermissionAttachmentInfo::getPermission).collect(Collectors.toList());
    }

    default public Optional<Long> getDurationInSeconds(CommandSender player, String permission) {
        return this.getDurationInMillis(player, permission).map(d -> d / 1000L);
    }

    default public Optional<Long> getDurationInMillis(CommandSender player, String permission) {
        return this.getPermissions(player).stream().filter(p -> p.startsWith(permission + ".")).map(p -> TimeUnitShort.getDurationFromString(p.substring(p.lastIndexOf(".") + 1))).max(Comparator.naturalOrder());
    }

    @Override
    public boolean has(Player var1, String var2);

    public boolean has(OfflinePlayer var1, String var2);

    public boolean hasAny(CommandSender var1, String ... var2);

    public boolean hasAny(CommandSender var1, Set<String> var2);

    public void validate(CommandSender var1, String var2);

    public void validateAny(CommandSender var1, Set<String> var2);

    public void validateAny(CommandSender var1, String ... var2);

    public boolean hasOnly(Player var1, String var2);

    @Override
    public boolean has(CommandSender var1, String var2);

    public int getStaffCount();

    default public void validateOp(CommandSender sender) {
        if (!sender.isOp()) {
            throw new NoPermissionException();
        }
    }

    default public void validateDuration(CommandSender player, String permission, long durationInMillis) {
        if (!(player instanceof Player)) {
            return;
        }
        List<String> permissions = this.getPermissions(player);
        if (permissions.stream().noneMatch(p -> p.startsWith(permission))) {
            return;
        }
        Optional<Long> duration = this.getDurationInMillis(player, permission);
        if (duration.isPresent() && duration.get() < durationInMillis) {
            throw new NoDurationPermissionException();
        }
    }
}

