/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.permissions;

import java.util.Arrays;
import java.util.Set;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.common.exceptions.NoPermissionException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.permissions.AnjoPermissionsHandler;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;

public class GroupManagerPermissionHandler
implements PermissionHandler {
    private final Options options;
    private final GroupManager gMplugin;

    public GroupManagerPermissionHandler(Options options) {
        this.options = options;
        PluginManager pluginManager = StaffPlusPlus.get().getServer().getPluginManager();
        this.gMplugin = (GroupManager)pluginManager.getPlugin("GroupManager");
    }

    @Override
    public boolean has(Player player, String permission) {
        if (permission == null) {
            return true;
        }
        boolean hasPermission = false;
        if (player != null) {
            AnjoPermissionsHandler worldPermissions = this.gMplugin.getWorldsHolder().getWorldPermissions(player);
            hasPermission = worldPermissions.has(player, permission);
        }
        return hasPermission;
    }

    @Override
    public boolean has(OfflinePlayer player, String permission) {
        if (permission == null) {
            return true;
        }
        boolean hasPermission = false;
        if (player != null) {
            AnjoPermissionsHandler worldPermissions = this.gMplugin.getWorldsHolder().getWorldPermissionsByPlayerName(player.getName());
            hasPermission = worldPermissions.permission(player.getName(), permission);
        }
        return hasPermission;
    }

    @Override
    public boolean hasAny(CommandSender player, String ... permissions) {
        return Arrays.stream(permissions).anyMatch(permission -> this.has(player, (String)permission));
    }

    @Override
    public boolean hasAny(CommandSender player, Set<String> permissions) {
        return permissions.stream().anyMatch(permission -> this.has(player, (String)permission));
    }

    @Override
    public void validate(CommandSender player, String permission) {
        if (permission != null && !this.has(player, permission)) {
            throw new NoPermissionException();
        }
    }

    @Override
    public void validateAny(CommandSender player, Set<String> permissions) {
        if (!permissions.isEmpty() && !this.hasAny(player, permissions)) {
            throw new NoPermissionException();
        }
    }

    @Override
    public void validateAny(CommandSender player, String ... permissions) {
        if (permissions.length != 0 && !this.hasAny(player, permissions)) {
            throw new NoPermissionException();
        }
    }

    @Override
    public boolean hasOnly(Player player, String permission) {
        if (permission == null) {
            return true;
        }
        boolean hasPermission = false;
        if (player != null) {
            AnjoPermissionsHandler worldPermissions = this.gMplugin.getWorldsHolder().getWorldPermissions(player);
            hasPermission = worldPermissions.has(player, permission);
        }
        return hasPermission;
    }

    @Override
    public boolean has(CommandSender sender, String permission) {
        if (permission == null || !(sender instanceof Player)) {
            return true;
        }
        AnjoPermissionsHandler worldPermissions = this.gMplugin.getWorldsHolder().getWorldPermissions((Player)sender);
        return worldPermissions.has((Player)sender, permission);
    }

    @Override
    public int getStaffCount() {
        int count = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.has(player, this.options.permissionMember)) continue;
            ++count;
        }
        return count;
    }
}

