/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.permissions;

import java.util.Arrays;
import java.util.Set;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.exceptions.NoPermissionException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DefaultPermissionHandler
implements PermissionHandler {
    @ConfigProperty(value="permissions:member")
    private String permissionMember;

    @Override
    public boolean has(Player player, String permission) {
        if (permission == null) {
            return true;
        }
        boolean hasPermission = false;
        if (player != null) {
            hasPermission = player.hasPermission(permission);
        }
        return hasPermission;
    }

    @Override
    public boolean has(OfflinePlayer player, String permission) {
        return permission == null;
    }

    @Override
    public boolean hasAny(CommandSender player, String ... permissions) {
        return Arrays.stream(permissions).anyMatch(permission -> this.has(player, (String)permission));
    }

    @Override
    public boolean hasAny(CommandSender player, Set<String> permissions) {
        return permissions.stream().anyMatch(permission -> this.has(player, (String)permission));
    }

    @Override
    public void validate(CommandSender player, String permission) {
        if (permission != null && !this.has(player, permission)) {
            throw new NoPermissionException();
        }
    }

    @Override
    public void validateAny(CommandSender player, Set<String> permissions) {
        if (!permissions.isEmpty() && !this.hasAny(player, permissions)) {
            throw new NoPermissionException();
        }
    }

    @Override
    public void validateAny(CommandSender player, String ... permissions) {
        if (permissions.length != 0 && !this.hasAny(player, permissions)) {
            throw new NoPermissionException();
        }
    }

    @Override
    public boolean hasOnly(Player player, String permission) {
        if (permission == null) {
            return true;
        }
        boolean hasPermission = false;
        if (player != null) {
            hasPermission = player.hasPermission(permission);
        }
        return hasPermission;
    }

    @Override
    public boolean has(CommandSender sender, String permission) {
        if (permission == null) {
            return true;
        }
        return sender.hasPermission(permission);
    }

    @Override
    public int getStaffCount() {
        int count = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.has(player, this.permissionMember)) continue;
            ++count;
        }
        return count;
    }
}

