/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.gui.style;

import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:show-style-info", permissions={"permissions:show-style-info"}, description="Toggle seeing style ids inside the Staff++ guis")
@IocBean
@IocMultiProvider(value={SppCommand.class})
public class ShowStyleInfoCommand
extends AbstractCmd {
    private final OnlineSessionsManager onlineSessionsManager;

    public ShowStyleInfoCommand(Messages messages, PermissionHandler permissionHandler, CommandService commandService, OnlineSessionsManager onlineSessionsManager) {
        super(messages, permissionHandler, commandService);
        this.onlineSessionsManager = onlineSessionsManager;
    }

    @Override
    public boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        this.validateIsPlayer(sender);
        PlayerSession playerSession = this.onlineSessionsManager.get((Player)sender);
        playerSession.setCanViewStyleIds(!playerSession.isCanViewStyleIds());
        this.messages.send(sender, "Style info " + (playerSession.isCanViewStyleIds() ? "enabled" : "disabled"), this.messages.prefixGeneral);
        return true;
    }

    @Override
    public int getMinimumArguments(CommandSender sender, String[] args) {
        return 0;
    }

    @Override
    public Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.empty();
    }
}

