/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.gui.gradient;

import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class GradientColorProcessor {
    private static final Pattern pattern = Pattern.compile("<#([0-9A-Fa-f]{6})>(.*?)</#([0-9A-Fa-f]{6})>");
    private static final List<String> SPECIAL_COLORS = Arrays.asList("&l", "&n", "&o", "&k", "&m", "\u00a7l", "\u00a7n", "\u00a7o", "\u00a7k", "\u00a7m");
    private static final Map<Color, ChatColor> COLORS = ImmutableMap.builder().put((Object)new Color(0), (Object)ChatColor.getByChar((char)'0')).put((Object)new Color(170), (Object)ChatColor.getByChar((char)'1')).put((Object)new Color(43520), (Object)ChatColor.getByChar((char)'2')).put((Object)new Color(43690), (Object)ChatColor.getByChar((char)'3')).put((Object)new Color(0xAA0000), (Object)ChatColor.getByChar((char)'4')).put((Object)new Color(0xAA00AA), (Object)ChatColor.getByChar((char)'5')).put((Object)new Color(0xFFAA00), (Object)ChatColor.getByChar((char)'6')).put((Object)new Color(0xAAAAAA), (Object)ChatColor.getByChar((char)'7')).put((Object)new Color(0x555555), (Object)ChatColor.getByChar((char)'8')).put((Object)new Color(0x5555FF), (Object)ChatColor.getByChar((char)'9')).put((Object)new Color(0x55FF55), (Object)ChatColor.getByChar((char)'a')).put((Object)new Color(0x55FFFF), (Object)ChatColor.getByChar((char)'b')).put((Object)new Color(0xFF5555), (Object)ChatColor.getByChar((char)'c')).put((Object)new Color(0xFF55FF), (Object)ChatColor.getByChar((char)'d')).put((Object)new Color(0xFFFF55), (Object)ChatColor.getByChar((char)'e')).put((Object)new Color(0xFFFFFF), (Object)ChatColor.getByChar((char)'f')).build();

    public static String process(String string) {
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String start = matcher.group(1);
            String end = matcher.group(3);
            String content = matcher.group(2);
            string = string.replace(matcher.group(), GradientColorProcessor.color(content, new Color(Integer.parseInt(start, 16)), new Color(Integer.parseInt(end, 16))));
        }
        return string;
    }

    public static String color(String string, Color start, Color end) {
        ChatColor[] colors = GradientColorProcessor.createGradient(start, end, GradientColorProcessor.withoutSpecialChar(string).length());
        return GradientColorProcessor.apply(string, colors);
    }

    private static String apply(String source, ChatColor[] colors) {
        StringBuilder specialColors = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        String[] characters = source.split("");
        int outIndex = 0;
        for (int i = 0; i < characters.length; ++i) {
            if (characters[i].equals("&") || characters[i].equals("\u00a7")) {
                if (i + 1 < characters.length) {
                    if (characters[i + 1].equals("r")) {
                        specialColors.setLength(0);
                    } else {
                        specialColors.append(characters[i]);
                        specialColors.append(characters[i + 1]);
                    }
                    ++i;
                    continue;
                }
                stringBuilder.append(colors[outIndex++]).append((CharSequence)specialColors).append(characters[i]);
                continue;
            }
            stringBuilder.append(colors[outIndex++]).append((CharSequence)specialColors).append(characters[i]);
        }
        return stringBuilder.toString();
    }

    private static String withoutSpecialChar(String source) {
        String workingString = source;
        for (String color : SPECIAL_COLORS) {
            if (!workingString.contains(color)) continue;
            workingString = workingString.replace(color, "");
        }
        return workingString;
    }

    private static ChatColor[] createGradient(Color start, Color end, int step) {
        ChatColor[] colors = new ChatColor[step];
        int stepR = Math.abs(start.getRed() - end.getRed()) / (step - 1);
        int stepG = Math.abs(start.getGreen() - end.getGreen()) / (step - 1);
        int stepB = Math.abs(start.getBlue() - end.getBlue()) / (step - 1);
        int[] direction = new int[]{start.getRed() < end.getRed() ? 1 : -1, start.getGreen() < end.getGreen() ? 1 : -1, start.getBlue() < end.getBlue() ? 1 : -1};
        for (int i = 0; i < step; ++i) {
            Color color = new Color(start.getRed() + stepR * i * direction[0], start.getGreen() + stepG * i * direction[1], start.getBlue() + stepB * i * direction[2]);
            colors[i] = ChatColor.of((Color)color);
        }
        return colors;
    }

    private static ChatColor getClosestColor(Color color) {
        Color nearestColor = null;
        double nearestDistance = 2.147483647E9;
        for (Color constantColor : COLORS.keySet()) {
            double distance = Math.pow(color.getRed() - constantColor.getRed(), 2.0) + Math.pow(color.getGreen() - constantColor.getGreen(), 2.0) + Math.pow(color.getBlue() - constantColor.getBlue(), 2.0);
            if (!(nearestDistance > distance)) continue;
            nearestColor = constantColor;
            nearestDistance = distance;
        }
        return COLORS.get(nearestColor);
    }
}

