/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.gui;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGui;
import net.shortninja.staffplus.core.common.Items;
import org.bukkit.inventory.ItemStack;

public class PagedGuiBuilder {
    private static final int SIZE = 54;

    public static class Builder
    extends TubingGui.Builder {
        public Builder(String title) {
            super(title, 54);
        }

        public Builder addPagedItems(String action, List<ItemStack> items, int currentPage) {
            int index = 0;
            for (ItemStack item : items) {
                this.addItem("$NOOP", index, item);
                ++index;
            }
            this.addFooter(action, currentPage);
            return this;
        }

        public <T> Builder addPagedItems(String action, Collection<T> items, Function<T, ItemStack> itemStackProvider, Function<T, String> actionProvider, int currentPage) {
            int index = 0;
            for (T item : items) {
                this.addItem(actionProvider.apply(item), index, itemStackProvider.apply(item));
                ++index;
            }
            this.addFooter(action, currentPage);
            return this;
        }

        public <T> Builder addPagedItems(String action, Collection<T> items, Function<T, ItemStack> itemStackProvider, Function<T, String> leftActionProvider, Function<T, String> rightActionProvider, int currentPage) {
            int index = 0;
            for (T item : items) {
                this.addItem(leftActionProvider.apply(item), rightActionProvider.apply(item), index, itemStackProvider.apply(item));
                ++index;
            }
            this.addFooter(action, currentPage);
            return this;
        }

        public Builder backAction() {
            this.addItem("$BACK", 49, Items.createDoor("Back", "Go back"));
            return this;
        }

        public Builder addPagedItems(String action, Consumer<Builder> itemProvider, int currentPage) {
            itemProvider.accept(this);
            this.addFooter(action, currentPage);
            return this;
        }

        private void addFooter(String action, int currentPage) {
            this.addNextPageItem(this, 53, action, currentPage);
            this.addNextPageItem(this, 52, action, currentPage);
            this.addNextPageItem(this, 51, action, currentPage);
            if (currentPage != 0) {
                this.addPreviousPageItem(this, 45, action, currentPage);
                this.addPreviousPageItem(this, 46, action, currentPage);
                this.addPreviousPageItem(this, 47, action, currentPage);
            }
        }

        private void addNextPageItem(Builder builder, int slot, String action, int currentPage) {
            ItemStack item = Items.editor(Items.createGreenColoredGlass("Next Page", "")).setAmount(1).build();
            String actionQuery = GuiActionBuilder.fromAction(action).param("page", String.valueOf(currentPage + 1)).build();
            builder.addItem(actionQuery, slot, item);
        }

        private void addPreviousPageItem(Builder builder, int slot, String action, int currentPage) {
            ItemStack item = Items.editor(Items.createRedColoredGlass("Previous Page", "")).setAmount(1).build();
            String actionQuery = GuiActionBuilder.fromAction(action).param("page", String.valueOf(currentPage - 1)).build();
            builder.addItem(actionQuery, slot, item);
        }
    }
}

