/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.shortninja.staffplus.core.common.JavaUtils;

public class LoreBuilder {
    private List<String> lore = new ArrayList<String>();
    private String labelColor;
    private String valueColor;

    private LoreBuilder(String labelColor, String valueColor) {
        this.labelColor = labelColor;
        this.valueColor = valueColor;
    }

    public static LoreBuilder builder(String labelColor, String valueColor) {
        return new LoreBuilder(labelColor, valueColor);
    }

    public LoreBuilder addItem(String value) {
        this.addItem(value, true);
        return this;
    }

    public LoreBuilder addItem(String value, boolean shouldAdd) {
        if (shouldAdd) {
            this.lore.add(this.valueColor + value);
        }
        return this;
    }

    public LoreBuilder addItem(String label, String value) {
        this.addItem(label, value, true);
        return this;
    }

    public LoreBuilder addItem(String label, String value, boolean shouldAdd) {
        if (shouldAdd) {
            this.lore.add(this.labelColor + label + ": " + this.valueColor + value);
        }
        return this;
    }

    public LoreBuilder addItem(String label, Supplier<String> value, boolean shouldAdd) {
        if (shouldAdd) {
            this.lore.add(this.labelColor + label + ": " + this.valueColor + value.get());
        }
        return this;
    }

    public LoreBuilder addIndented(String label, String value) {
        this.addIndented(label, value, true);
        return this;
    }

    public LoreBuilder addIndented(String label, Supplier<String> value, boolean shouldAdd) {
        if (shouldAdd) {
            this.addIndented(label, value.get(), true);
        }
        return this;
    }

    public LoreBuilder addIndented(String label, String value, boolean shouldAdd) {
        if (shouldAdd) {
            this.addMultiLineIntended(label, JavaUtils.formatLines(value, 30));
        }
        return this;
    }

    public LoreBuilder addDuration(String label, String humanReadableDuration, boolean shouldAdd) {
        if (shouldAdd) {
            this.addMultiLineIntended(label, Arrays.asList(humanReadableDuration.split(", ")));
        }
        return this;
    }

    private void addMultiLineIntended(String label, List<String> lines) {
        this.lore.add(this.labelColor + label + ":");
        for (String line : lines) {
            this.lore.add("  " + this.valueColor + line);
        }
    }

    public List<String> build() {
        return this.lore;
    }
}

