/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.common.Items;
import net.shortninja.staffplus.core.common.gui.IAction;
import net.shortninja.staffplus.core.common.gui.IGui;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractGui
implements IGui {
    protected final Messages messages = StaffPlusPlus.get().getIocContainer().get(Messages.class);
    protected final OnlineSessionsManager sessionManager = StaffPlusPlus.get().getIocContainer().get(OnlineSessionsManager.class);
    protected final Options options = StaffPlusPlus.get().getIocContainer().get(Options.class);
    private final String title;
    protected Supplier<AbstractGui> previousGuiSupplier;
    private final Inventory inventory;
    private final Map<Integer, IAction> actions = new HashMap<Integer, IAction>();

    public AbstractGui(String title, InventoryType inventoryType) {
        this.title = title;
        this.inventory = Bukkit.createInventory(null, (InventoryType)inventoryType);
    }

    public AbstractGui(int size, String title) {
        this.title = title;
        this.inventory = Bukkit.createInventory(null, (int)size, (String)this.messages.colorize(title));
    }

    public AbstractGui(int size, String title, Supplier<AbstractGui> previousGuiSupplier) {
        this.title = title;
        this.inventory = Bukkit.createInventory(null, (int)size, (String)this.messages.colorize(title));
        this.previousGuiSupplier = previousGuiSupplier;
    }

    public abstract void buildGui();

    public void show(Player player) {
        this.buildGui();
        if (this.previousGuiSupplier != null) {
            ItemStack item = Items.editor(Items.createDoor("Back", "Go back")).setAmount(1).build();
            this.setItem(this.getBackButtonSlot(), item, new IAction(){

                @Override
                public void click(Player player, ItemStack item, int slot, ClickType clickType) {
                    AbstractGui.this.previousGuiSupplier.get().show(player);
                }

                @Override
                public boolean shouldClose(Player player) {
                    return false;
                }
            });
        }
        player.closeInventory();
        player.openInventory(this.getInventory());
        this.sessionManager.get(player).setCurrentGui(this);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public IAction getAction(int slot) {
        return this.actions.get(slot);
    }

    @Override
    public void setItem(int slot, ItemStack item, IAction action) {
        this.inventory.setItem(slot, item);
        if (action != null) {
            this.actions.put(slot, action);
        }
    }

    protected int getBackButtonSlot() {
        return 49;
    }
}

