/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.cmd;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.authentication.AuthenticationService;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.cmd.CommandPlayerRetriever;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.arguments.ArgumentProcessor;
import net.shortninja.staffplus.core.common.cmd.arguments.ArgumentType;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.actions.delayedactions.DelayArgumentExecutor;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@IocBean
public class CommandService {
    private final PermissionHandler permissionHandler;
    private final CommandPlayerRetriever commandPlayerRetriever;
    private final DelayArgumentExecutor delayArgumentExecutor;
    private final AuthenticationService authenticationService;
    private final ArgumentProcessor argumentProcessor;

    public CommandService(PermissionHandler permissionHandler, CommandPlayerRetriever commandPlayerRetriever, DelayArgumentExecutor delayArgumentExecutor, AuthenticationService authenticationService, ArgumentProcessor argumentProcessor) {
        this.permissionHandler = permissionHandler;
        this.commandPlayerRetriever = commandPlayerRetriever;
        this.delayArgumentExecutor = delayArgumentExecutor;
        this.authenticationService = authenticationService;
        this.argumentProcessor = argumentProcessor;
    }

    public void processArguments(CommandSender sender, String[] args, String playerName, List<ArgumentType> executionSppArguments) {
        this.argumentProcessor.parseArguments(sender, playerName, args, executionSppArguments);
    }

    public void validateAuthentication(boolean authenticate, CommandSender sender) {
        if (authenticate && sender instanceof Player) {
            this.authenticationService.checkAuthentication((Player)sender);
        }
    }

    public void validatePermissions(CommandSender sender, Set<String> permissions) {
        this.permissionHandler.validateAny(sender, permissions);
    }

    public Optional<SppPlayer> retrievePlayer(String[] args, String playerName, PlayerRetrievalStrategy playerRetrievalStrategy, boolean isDelayable) {
        return this.commandPlayerRetriever.retrievePlayer(playerRetrievalStrategy, playerName, this.shouldDelay(args, isDelayable));
    }

    public boolean shouldDelay(String[] args, boolean isDelayable) {
        return isDelayable && Arrays.asList(args).contains(this.delayArgumentExecutor.getType().getPrefix());
    }

    public void delayCommand(CommandSender sender, String alias, String[] args, String playerName) {
        String delayedCommand = alias + " " + Stream.of(args).filter(a -> !a.equals(this.delayArgumentExecutor.getType().getPrefix())).collect(Collectors.joining(" "));
        this.delayArgumentExecutor.execute(sender, playerName, delayedCommand);
    }

    public List<String> getSppArgumentsTabCompletion(List<ArgumentType> validTypes, String[] args) {
        return validTypes.stream().filter(t -> Arrays.stream(args).noneMatch(a -> a.startsWith(t.getPrefix()))).map(ArgumentType::getPrefix).collect(Collectors.toList());
    }

    public List<String> getSppArgumentTabCompletion(String currentArg, ArgumentType argumentType) {
        return this.argumentProcessor.getTabCompletion(currentArg, argumentType);
    }
}

