/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.cmd;

import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.exceptions.PlayerOfflineException;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplusplus.session.SppPlayer;

@IocBean
public class CommandPlayerRetriever {
    private final PlayerManager playerManager;
    private final Messages messages;

    public CommandPlayerRetriever(PlayerManager playerManager, Messages messages) {
        this.playerManager = playerManager;
        this.messages = messages;
    }

    public Optional<SppPlayer> retrievePlayer(PlayerRetrievalStrategy strategy, String playerName, boolean delayed) {
        if (strategy == PlayerRetrievalStrategy.NONE) {
            return Optional.empty();
        }
        if (playerName == null) {
            if (strategy == PlayerRetrievalStrategy.OPTIONAL_BOTH || strategy == PlayerRetrievalStrategy.OPTIONAL_ONLINE) {
                return Optional.empty();
            }
            throw new IllegalArgumentException("playerName cannot be null with non-optional strategy");
        }
        SppPlayer player = this.playerManager.getOnOrOfflinePlayer(playerName).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
        switch (strategy) {
            case BOTH: 
            case OPTIONAL_BOTH: {
                return Optional.of(player);
            }
            case ONLINE: 
            case OPTIONAL_ONLINE: {
                if (!player.isOnline() && !delayed) {
                    throw new PlayerOfflineException();
                }
                return Optional.of(player);
            }
        }
        return Optional.empty();
    }
}

