/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.cmd;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.bootstrap.PluginDisable;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMulti;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.ReflectionUtils;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigurationLoader;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.TubingBukkitPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.BeforeTubingReload;
import net.shortninja.staffplus.core.common.IProtocolService;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.BaseCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.exceptions.ConfigurationException;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

@IocBean
@IocMultiProvider(value={PluginDisable.class, BeforeTubingReload.class})
public class CmdHandler
implements PluginDisable,
BeforeTubingReload {
    private final IProtocolService versionProtocol;
    private final ConfigurationLoader configurationLoader;
    private final List<SppCommand> sppCommands;
    private final Messages messages;
    public List<BaseCmd> commands;

    public CmdHandler(IProtocolService protocolService, ConfigurationLoader configurationLoader, @IocMulti(value=SppCommand.class) List<SppCommand> sppCommands, Messages messages) {
        this.versionProtocol = protocolService;
        this.configurationLoader = configurationLoader;
        this.sppCommands = sppCommands;
        this.messages = messages;
        this.registerCommands();
    }

    private void registerCommands() {
        this.commands = this.sppCommands.stream().peek(this::processCommandAnnotation).filter(s -> StringUtils.isNotBlank(((BukkitCommand)s).getName())).map(sppCommand -> new BaseCmd(this.messages, (org.bukkit.command.Command)sppCommand)).collect(Collectors.toList());
        this.commands.forEach(baseCmd -> {
            this.versionProtocol.getVersionProtocol().registerCommand(baseCmd.getMatch(), baseCmd.getCommand());
            for (String permission : baseCmd.getPermissions()) {
                Bukkit.getServer().getPluginManager().addPermission(new Permission(permission, PermissionDefault.FALSE));
            }
        });
    }

    private void processCommandAnnotation(SppCommand s) {
        Command command = s.getClass().getAnnotation(Command.class);
        if (command != null) {
            List commandNames;
            Set<String> permissions = Arrays.stream(command.permissions()).filter(StringUtils::isNotBlank).map(p -> (String)ReflectionUtils.getConfigValue(p, this.configurationLoader.getConfigurationFiles()).orElseThrow(() -> new ConfigurationException("Invalid permission: " + p))).collect(Collectors.toSet());
            AbstractCmd abstractCmd = (AbstractCmd)s;
            abstractCmd.setPermissions(permissions);
            abstractCmd.setAsync(command.async());
            abstractCmd.setDescription(command.description());
            abstractCmd.setUsage(command.usage());
            abstractCmd.setDelayable(command.delayable());
            abstractCmd.setReplaceDoubleQoutesEnabled(command.replaceDoubleQuotes());
            abstractCmd.setPlayerRetrievalStrategy(command.playerRetrievalStrategy());
            if (StringUtils.isNotBlank(command.command()) && (commandNames = (List)ReflectionUtils.getConfigValue(command.command(), this.configurationLoader.getConfigurationFiles()).orElseThrow(() -> new ConfigurationException("Invalid command name: " + command.command()))).size() > 0) {
                abstractCmd.setName((String)commandNames.get(0));
                abstractCmd.setAliases(commandNames);
            }
        }
    }

    @Override
    public void disable(StaffPlusPlus staffPlusPlus) {
        this.commands.forEach(baseCmd -> this.versionProtocol.getVersionProtocol().unregisterCommand(baseCmd.getMatch(), baseCmd.getCommand()));
    }

    @Override
    public void execute(TubingBukkitPlugin tubingPlugin) {
        this.commands.forEach(baseCmd -> this.versionProtocol.getVersionProtocol().unregisterCommand(baseCmd.getMatch(), baseCmd.getCommand()));
    }
}

