/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.cmd;

import java.util.ArrayList;
import java.util.List;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import org.bukkit.command.Command;

public class BaseCmd {
    private Command command;
    private String match;
    private String description;
    private String usage;
    private List<String> permissions = new ArrayList<String>();

    public BaseCmd(Messages messages, Command command) {
        this.command = command;
        this.match = StaffPlusPlus.get().getDescription().getName();
        this.description = messages.colorize(command.getDescription());
        this.usage = "/" + command.getName() + " " + command.getUsage();
        this.command.setPermissionMessage(messages.colorize(messages.noPermission));
        this.command.setDescription(this.description);
        this.command.setUsage(this.usage);
    }

    public Command getCommand() {
        return this.command;
    }

    public String getMatch() {
        return this.match;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }
}

