/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.cmd.arguments.ArgumentType;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCmd
extends BukkitCommand
implements SppCommand {
    private static final String SPACE_REPLACER = "%space%";
    protected final Messages messages;
    protected final PermissionHandler permissionHandler;
    private final CommandService commandService;
    private boolean delayable;
    private boolean replaceDoubleQoutesEnabled;
    private PlayerRetrievalStrategy playerRetrievalStrategy = PlayerRetrievalStrategy.NONE;
    private Set<String> permissions = new HashSet<String>();
    private final Map<UUID, Long> lastUse = new HashMap<UUID, Long>();
    private boolean async;

    protected AbstractCmd(String name, Messages messages, PermissionHandler permissionHandler, CommandService commandService) {
        super(name);
        this.messages = messages;
        this.permissionHandler = permissionHandler;
        this.commandService = commandService;
    }

    protected AbstractCmd(Messages messages, PermissionHandler permissionHandler, CommandService commandService) {
        super("");
        this.messages = messages;
        this.permissionHandler = permissionHandler;
        this.commandService = commandService;
    }

    protected Player validateIsPlayer(CommandSender sender) {
        if (!(sender instanceof Player)) {
            throw new BusinessException(this.messages.onlyPlayers);
        }
        return (Player)sender;
    }

    public boolean execute(CommandSender sender, String alias, String[] args) {
        try {
            Optional<SppPlayer> player;
            if (args.length > 0 && this.replaceDoubleQoutesEnabled) {
                args = this.replaceDoubleQoutes(args);
            }
            this.commandService.validateAuthentication(this.isAuthenticationRequired(), sender);
            this.commandService.validatePermissions(sender, this.permissions);
            this.validateCoolDown(sender);
            String[] optionalParamaters = (String[])Arrays.stream(args).filter(a -> this.getOptionalParameters().stream().anyMatch(a::startsWith)).toArray(String[]::new);
            String[] filteredArgs = (String[])Arrays.stream(args).filter(a -> this.getOptionalParameters().stream().noneMatch(a::startsWith)).toArray(String[]::new);
            String[] sppArgs = (String[])Arrays.stream(filteredArgs).filter(a -> this.getSppArguments().stream().map(ArgumentType::getPrefix).anyMatch(a::startsWith)).toArray(String[]::new);
            filteredArgs = (String[])Arrays.stream(filteredArgs).filter(a -> this.getSppArguments().stream().map(ArgumentType::getPrefix).noneMatch(a::startsWith)).toArray(String[]::new);
            this.validateMinimumArguments(sender, filteredArgs);
            String playerName = this.getPlayerName(sender, filteredArgs).orElse(null);
            try {
                player = this.commandService.retrievePlayer(sppArgs, playerName, this.getPlayerRetrievalStrategy(), this.delayable);
            }
            catch (IllegalArgumentException ignored) {
                throw new BusinessException(this.messages.invalidArguments.replace("%usage%", " &7" + this.getUsage()));
            }
            if (player.isPresent()) {
                if (player.get().isOnline() && this.canBypass(player.get().getPlayer())) {
                    throw new BusinessException(this.messages.bypassed, this.messages.prefixGeneral);
                }
                if (this.commandService.shouldDelay(sppArgs, this.delayable)) {
                    this.commandService.delayCommand(sender, alias, filteredArgs, player.get().getUsername());
                    return true;
                }
            }
            this.validateExecution(player.orElse(null));
            this.commandService.processArguments(sender, sppArgs, playerName, this.getPreExecutionSppArguments());
            boolean result = true;
            if (!this.async) {
                result = this.executeCmd(sender, alias, filteredArgs, player.orElse(null), this.mapOptionalParameters(optionalParamaters));
            } else {
                String[] finalFilteredArgs = filteredArgs;
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)StaffPlusPlus.get(), () -> {
                    try {
                        this.executeCmd(sender, alias, finalFilteredArgs, player.orElse(null), this.mapOptionalParameters(optionalParamaters));
                    }
                    catch (BusinessException e) {
                        this.messages.send(sender, e.getMessage(), e.getPrefix());
                    }
                });
            }
            this.commandService.processArguments(sender, sppArgs, playerName, this.getPostExecutionSppArguments());
            if (sender instanceof Player) {
                this.lastUse.put(((Player)sender).getUniqueId(), System.currentTimeMillis());
            }
            return result;
        }
        catch (BusinessException e) {
            this.messages.send(sender, e.getMessage(), e.getPrefix());
            return false;
        }
    }

    @NotNull
    private String[] replaceDoubleQoutes(String[] args) {
        String joined = String.join((CharSequence)" ", args);
        List<String> allMatches = this.getAllMatches(joined, "(\"(?:[^\"\\\\\n]|\\\\.)*\")");
        for (String match : allMatches) {
            joined = joined.replace(match, match.replaceAll("\\s+", SPACE_REPLACER));
        }
        return joined.split(" ");
    }

    private void validateCoolDown(CommandSender sender) {
        Optional<Long> cooldown;
        if (sender instanceof Player && (cooldown = this.permissionHandler.getDurationInSeconds(sender, "staff." + this.getName() + ".cooldown")).isPresent() && this.lastUse.containsKey(((Player)sender).getUniqueId())) {
            long last = this.lastUse.get(((Player)sender).getUniqueId());
            long secondsOnCooldown = (System.currentTimeMillis() - last) / 1000L;
            if (secondsOnCooldown < cooldown.get()) {
                throw new BusinessException(this.messages.commandOnCooldown.replace("%seconds%", Long.toString(cooldown.get() - secondsOnCooldown)), this.messages.prefixGeneral);
            }
        }
    }

    private Map<String, String> mapOptionalParameters(String[] optionalParamaters) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String optionalParamater : optionalParamaters) {
            String[] templateParams = optionalParamater.split("=");
            if (templateParams.length != 2) {
                result.put(templateParams[0], null);
                continue;
            }
            result.put(templateParams[0], templateParams[1].replaceAll("^\"|\"$", "").replace(SPACE_REPLACER, " "));
        }
        return result;
    }

    public void setPermission(String permission) {
        this.permissions.add(permission);
    }

    private List<ArgumentType> getSppArguments() {
        List<ArgumentType> collect = Stream.of(this.getPreExecutionSppArguments(), this.getPostExecutionSppArguments()).flatMap(Collection::stream).collect(Collectors.toList());
        if (this.delayable) {
            collect.add(ArgumentType.DELAY);
        }
        return collect;
    }

    protected PlayerRetrievalStrategy getPlayerRetrievalStrategy() {
        return this.playerRetrievalStrategy;
    }

    protected void validateExecution(SppPlayer player) {
    }

    protected List<String> getOptionalParameters() {
        return Collections.emptyList();
    }

    protected List<ArgumentType> getPreExecutionSppArguments() {
        return Collections.emptyList();
    }

    protected List<ArgumentType> getPostExecutionSppArguments() {
        return Collections.emptyList();
    }

    protected boolean canBypass(Player player) {
        return false;
    }

    protected abstract boolean executeCmd(CommandSender var1, String var2, String[] var3, SppPlayer var4, Map<String, String> var5);

    protected abstract int getMinimumArguments(CommandSender var1, String[] var2);

    protected boolean isAuthenticationRequired() {
        return true;
    }

    public void setPlayerRetrievalStrategy(PlayerRetrievalStrategy playerRetrievalStrategy) {
        this.playerRetrievalStrategy = playerRetrievalStrategy;
    }

    protected abstract Optional<String> getPlayerName(CommandSender var1, String[] var2);

    public void setDelayable(boolean delayable) {
        this.delayable = delayable;
    }

    public void setReplaceDoubleQoutesEnabled(boolean replaceDoubleQoutesEnabled) {
        this.replaceDoubleQoutesEnabled = replaceDoubleQoutesEnabled;
    }

    private void validateMinimumArguments(CommandSender sender, String[] args) {
        if (args.length < this.getMinimumArguments(sender, args)) {
            throw new BusinessException(this.messages.invalidArguments.replace("%usage%", " &7" + this.getUsage()));
        }
    }

    protected void setPermissions(Set<String> permissions) {
        if (!permissions.isEmpty()) {
            super.setPermission(permissions.iterator().next());
        }
        this.permissions = permissions;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        String[] filteredArgs = (String[])Arrays.stream(args).filter(a -> this.getSppArguments().stream().map(ArgumentType::getPrefix).noneMatch(a::startsWith)).toArray(String[]::new);
        String[] sppArgs = (String[])Arrays.stream(args).filter(a -> this.getSppArguments().stream().map(ArgumentType::getPrefix).anyMatch(a::startsWith)).toArray(String[]::new);
        String currentArg = args.length > 0 ? args[args.length - 1] : "";
        Optional<ArgumentType> matchedArgType = this.getSppArguments().stream().filter(a -> currentArg.startsWith(a.getPrefix())).findFirst();
        if (matchedArgType.isPresent()) {
            return this.commandService.getSppArgumentTabCompletion(currentArg, matchedArgType.get());
        }
        List<String> tabResults = this.autoComplete(sender, filteredArgs, sppArgs);
        if (tabResults.isEmpty()) {
            return this.commandService.getSppArgumentsTabCompletion(this.getSppArguments(), args);
        }
        return tabResults;
    }

    protected List<String> autoComplete(CommandSender sender, String[] args, String[] sppArgs) throws IllegalArgumentException {
        return Collections.emptyList();
    }

    private List<String> getAllMatches(String text, String regex) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher m = Pattern.compile("(?=(" + regex + "))").matcher(text);
        while (m.find()) {
            matches.add(m.group(1));
        }
        return matches;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }
}

